import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from "@angular/router";
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-team-sales-score',
  templateUrl: './team-sales-score.component.html',
  styleUrls: ['./team-sales-score.component.scss']
})
export class TeamSalesScoreComponent implements OnInit {
  showType: any;
  practitionerId: any;
  subordinateSystemName: any;
  playerSalesActivityInfo: Array<any>;
  constructor(private activateRoute: ActivatedRoute, private router: Router,
    private myService: MyService) { }

  ngOnInit() {
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.subordinateSystemName = sessionStorage.getItem('subordinateSystemName');
    //判断显示销售得分还是销售预测
    this.showType = this.activateRoute.snapshot.paramMap.get('type');
    console.log(this.showType)
    if (this.showType === 'teamSalesScore') {
      this.playerSalesActivityQuery()
    }
    if (this.showType === '') {

    }
  }

  //获取成员销售活动量得分
  playerSalesActivityQuery() {
    this.myService.playerSalesActivityQuery({ practitionerId: this.practitionerId }).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.playerSalesActivityInfo = res['data']['playerSalesActivityInfo']
      }
    })
  }
}
