import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-news-detail',
  templateUrl: './news-detail.component.html',
  styleUrls: ['./news-detail.component.scss']
})
export class NewsDetailComponent implements OnInit {
  type:string;
  messageId:string;
  systemMessageInfo:any;
  constructor(private router:Router,private activatedRoute:ActivatedRoute,private myService:MyService) { 
    this.type = activatedRoute.snapshot.queryParams['type'];
    this.messageId = activatedRoute.snapshot.params['id'];
  }

  ngOnInit() {
    if(this.messageId!=='000'){
      this.querySystemMessageDetail();
    }
  }

  close()
  {
    if(this.type==='1'){
      this.router.navigate(['/my'])
    }else{
      this.router.navigate(['/news'])
    }
  }
  // 查询消息详情
  querySystemMessageDetail(){
    this.myService.querySystemMessageDetail({systemMessageId:this.messageId}).subscribe(res=>{
      if(res['success']){
        this.systemMessageInfo = res['data']['systemMessageInfo'];
      }
    })
  }

}
