import axios from 'axios'
import environment  from '../environments/environment'
const API = environment.SFP;

// 创建axios实例
const service = axios.create({
    // baseURL: 'http://192.168.1.69:5000',
    baseURL: API,
    timeout: 80000, // 请求超时时间
     withCredentials: true,
    // crossDomain: true
})

// request拦截器
service.interceptors.request.use(
    config => {
        if (getToken()) {
             config.headers['Authorization'] = getToken() // 让每个请求携带自定义token 请根据实际情况自行修改
         }
        var lang = localStorage.getItem('lang')//因为项目中使用到了i18n国际化语言配置，请根据实际情况自行修改
        if (!lang) {
            lang = 'zh_CN'
        }
        config.headers['Accept-Language'] = lang.replace(/_/g, '-')
        config.headers['Content-Type'] = 'application/json'
        return config
    },
    error => {
        Promise.reject(error)
    }
)

// response 拦截器
service.interceptors.response.use(
    response => {
        return response.data
    },
    error => {
        // 兼容blob下载出错json提示
        if (error.response.data instanceof Blob && error.response.data.type.toLowerCase().indexOf('json') !== -1) {
            const reader = new FileReader()
            reader.readAsText(error.response.data, 'utf-8')
            reader.onload = function (e) {
                const errorMsg = JSON.parse(reader.result).message
                Notification.error({
                    title: errorMsg,
                    duration: 5000
                })
            }
        } else {
            let code = 0
            try {
                code = error.response.data.status
            } catch (e) {
                if (error.toString().indexOf('Error: timeout') !== -1) {
                    Notification.error({
                        title: '网络请求超时',
                        duration: 5000
                    })
                    return Promise.reject(error)
                }
            }

            if (code) {
                 if (code === 401) {
                     store.dispatch('LogOut').then(() => {
                         // 用户登录界面提示
                         Cookies.set('point', 401)
                         location.reload()
                    })
                 } else if (code === 403) {
                     router.push({ path: '/401' })
                 } else {
                const errorMsg = error.response.data.message
                if (errorMsg !== undefined) {
                    Notification.error({
                        title: errorMsg,
                        duration: 0
                    })
                }
              }
            } else {
                Notification.error({
                    title: '接口请求失败',
                    duration: 5000
                })
            }
        }
        return Promise.reject(error)
    }
)
export default service
