// pages/list/list.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    hasUserInfo:false,
    checkboxItems: [
      { name: '滑雪', value: 'skiing' },
      { name: '海滩', value: 'beach' },
      { name: '野营', value: 'camping' },
      { name: '徒步', value: 'hiking' }
    ],
    selectedWhere: null,
    selectedDays: null,
    selectedWash: null,
    selectedTemperature: null,
    selectedGender: null,
    btnActived: null,
    results: [],
    packingListEntry: {
      gender: null,
      temperature: null,
      ifWashClothes: null,
      region: null,
      travelDays: null,
      skiing: null,
      beach: null,
      camping: null,
      hiking: null
    }

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function () {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  // 多选点击事件
  checkboxChange: function (e) {
    var checkboxItems = this.data.checkboxItems, values = e.detail.value, packingListEntry = this.data.packingListEntry;
    for (var i = 0, lenI = checkboxItems.length; i < lenI; ++i) {
      checkboxItems[i].checked = false;
      for (var j = 0, lenJ = values.length; j < lenJ; ++j) {
        if (checkboxItems[i].value == values[j]) {
          checkboxItems[i].checked = true;
          break;
        }
      }
      if (checkboxItems[i].value === 'skiing') {
        if (checkboxItems[i].checked === true) {
          packingListEntry.skiing = 1
        } else {
          packingListEntry.skiing = null
        }
      } else if (checkboxItems[i].value === 'beach') {
        if (checkboxItems[i].checked === true) {
          packingListEntry.beach = 1
        } else {
          packingListEntry.beach = null
        }
      } else if (checkboxItems[i].value === 'camping') {
        if (checkboxItems[i].checked === true) {
          packingListEntry.camping = 1
        } else {
          packingListEntry.camping = null
        }
      } else if (checkboxItems[i].value === 'hiking') {
        if (checkboxItems[i].checked === true) {
          packingListEntry.hiking = 1
        } else {
          packingListEntry.hiking = null
        }
      }
    }
    this.setData({
      checkboxItems: checkboxItems,
      packingListEntry: packingListEntry
    });

  },

  //  选择目的地
  selectWhere: function (e) {
    var results = this.data.results;
    var packingListEntry = this.data.packingListEntry;
    results['selectedWhere'] = e.target.dataset;
    packingListEntry.region = e.target.dataset.value;
    this.setData({ selectedWhere: e.target.dataset.value, packingListEntry: packingListEntry });
    this.updateOptionResult();
  },
  //  选择天数
  selectDay: function (e) {
    var results = this.data.results;
    var packingListEntry = this.data.packingListEntry;
    results['selectedDays'] = e.target.dataset;
    packingListEntry.travelDays = e.target.dataset.value;
    this.setData({ selectedDays: e.target.dataset.value, packingListEntry: packingListEntry });
    this.updateOptionResult();
  },
  selectWash: function (e) {
    var results = this.data.results;
    var packingListEntry = this.data.packingListEntry;
    results['selectedWash'] = e.target.dataset;
    packingListEntry.ifWashClothes = e.target.dataset.value;
    this.setData({ selectedWash: e.target.dataset.value, packingListEntry: packingListEntry });
    this.updateOptionResult();
  },
  selectTemperature: function (e) {
    var results = this.data.results;
    var packingListEntry = this.data.packingListEntry;
    packingListEntry.temperature = e.target.dataset.value;
    results['selectedTemperature'] = e.target.dataset;
    this.setData({ selectedTemperature: e.target.dataset.value, packingListEntry: packingListEntry });
    this.updateOptionResult();
  },
  selectGender: function (e) {
    var results = this.data.results;
    var packingListEntry = this.data.packingListEntry;
    packingListEntry.gender = e.target.dataset.value;
    results['selectedGender'] = e.target.dataset;
    this.setData({ selectedGender: e.target.dataset.value, packingListEntry: packingListEntry });
    this.updateOptionResult();
  },

  // 生成列表
  makeLists: function (e) {
    wx.request({
      url: 'https://m.zuihuibi.cn/api/promotion/packingListQry',
      data: this.data.packingListEntry,
      method: 'POST',
      header: { 'X-Authorization': wx.getStorageSync('X-Authorization')},
      dataType: 'json',
      success: function (res) {
        wx.setStorageSync('packingCategoryList', res.data.data.packingCategoryList);
        wx.navigateTo({
          url: '../packinglist/packinglist',
        })
      }
    })

  },

  //  更新选项答案
  updateOptionResult: function () {
    var indexArray = [];
    for (var i in this.data.results) {
      indexArray.push(i);
    }
    var btnActived = indexArray.length === 5;
    this.setData({ btnActived, btnActived })
  }

})