// pages/packinglist/packinglist.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    // 弹出确认框
    refreshFlag: false,
    packingCategoryList: [],
    packingCategoryListEntry: []
  },
  save: function () {
    // 将 data 存储在本地缓存中指定的 key 中，会覆盖掉原来该 key 对应的内容，这是一个同步接口。
    wx.setStorageSync('packingCategoryList', this.data.packingCategoryList);

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function () {
    var packingCategoryList = wx.getStorageSync('packingCategoryList');
    if (!packingCategoryList) { var packingCategoryList = this.data.packingCategoryList };
    for (var i = 0; i < packingCategoryList.length; i++) {
      var length = packingCategoryList[i].packingItemList.length;
      packingCategoryList[i].input = '';
      packingCategoryList[i].newQuantity = 1;
      for (var j = 0; j < length; j++) {
        if (packingCategoryList[i].packingItemList[j].completed == null) {
          packingCategoryList[i].packingItemList[j].completed = true;
        }
      }
    }
    this.setData({ packingCategoryList: packingCategoryList });
    this.save();
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {


  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function (res) {
    if (res.from === 'button') {
      // 来自页面内转发按钮
      console.log(res.target)
    }
    return {
      title: '旅行达人出行必备的打包神器',
      path: 'pages/list/list',
      imageUrl: '../../images/share.jpg',
      success: function (res) {
        console.log(res)
        // 转发成功
      },
      fail: function (res) {
        // 转发失败
      }
    }
  },
  // 增加还是删除
  action: function (e) {
    var index = e.currentTarget.dataset.index;
    var subIndex = e.currentTarget.dataset.subindex;
    var packingCategoryList = this.data.packingCategoryList;
    packingCategoryList[index].packingItemList[subIndex].completed = !packingCategoryList[index].packingItemList[subIndex].completed;
    this.setData({
      packingCategoryList: packingCategoryList
    });
    this.save();
  },
  // ===== 事项内容事件处理函数 =====
  inputChangeHandle: function (e) {
    var index = e.currentTarget.dataset.index;
    var packingCategoryList = this.data.packingCategoryList;
    packingCategoryList[index].input = e.detail.value
    this.setData({ packingCategoryList: packingCategoryList });
  },
  // ====数量处理函数
  inputQuantityChangeHandle: function (e) {
    var index = e.currentTarget.dataset.index;
    var packingCategoryList = this.data.packingCategoryList;
    packingCategoryList[index].newQuantity = e.detail.value
    this.setData({ packingCategoryList: packingCategoryList });
    this.save();
  },
  // 单条数量修改
  quantityChangeHandle: function (e) {
    var index = e.currentTarget.dataset.index;
    var subIndex = e.currentTarget.dataset.subindex;
    var packingCategoryList = this.data.packingCategoryList;
    packingCategoryList[index].packingItemList[subIndex].quantity = e.detail.value
    this.setData({ packingCategoryList: packingCategoryList });
    this.save();
  },
  //  新增
  addTodoHandle: function (e) {
    var index = e.currentTarget.dataset.index;
    var categoryid = e.currentTarget.dataset.categoryid;
    var packingCategoryList = this.data.packingCategoryList
    if (!packingCategoryList[index].input || !packingCategoryList[index].input.trim()) return;
    packingCategoryList[index].packingItemList.push({ categoryId: categoryid, itemId: '-1', itemName: packingCategoryList[index].input, quantity: packingCategoryList[index].newQuantity, completed: true });
    packingCategoryList[index].input = '';
    packingCategoryList[index].newQuantity = 1;
    this.setData({
      packingCategoryList: packingCategoryList,
    });
    this.save();

  },
  // 创建新清单
  refresh: function (e) {
    var refreshFlag = this.data.refreshFlag;
    refreshFlag = true;
    this.setData({ refreshFlag: refreshFlag })
  },
  answer: function (e) {
    var value = e.target.dataset.value;
    var refreshFlag = this.data.refreshFlag;
    if (value === '1') {
      refreshFlag = true;
      wx.removeStorageSync('packingCategoryList')
      wx.switchTab({
        url: '/pages/list/list',
      })
    } else if (value === '0') {
      refreshFlag = false;
    }
    this.setData({ refreshFlag: refreshFlag })
  },
  saveLists: function (e) {
    var openId = wx.getStorageSync('openId');
    var packingCategoryList = wx.getStorageSync('packingCategoryList');
    var packingCategoryListEntry = this.data.packingCategoryListEntry;
    var packingItemLists = [];
    packingCategoryListEntry = packingCategoryList;
    for (let i = 0; i < packingCategoryListEntry.length; i++) {
      packingItemLists = packingCategoryListEntry[i].packingItemList;
      for (let j = 0; j < packingItemLists.length; j++) {
        if (packingItemLists[j].completed === false) {
          packingItemLists.splice(packingItemLists.indexOf(packingItemLists[j]), 1);
          j--;
        }
      }
      if (packingCategoryListEntry[i].packingItemList.length <= 0) {
        packingCategoryListEntry.splice(packingCategoryListEntry.indexOf(packingCategoryListEntry[i]), 1)
      }
    };
    // 用户打包清单保存接口
    wx.request({
      url: 'https://m.zuihuibi.cn/api/promotion/userPackingListSave',
      data: {
        openid: openId,
        packingCategoryList: packingCategoryListEntry
      },
      method: 'POST',
      header: { 'X-Authorization': wx.getStorageSync('X-Authorization') },
      dataType: 'json',
      success: function (res) {
        wx.showToast({
          title: '保存成功',
          icon: 'success',
          duration: 3000
        })
      },
      fail: function (res) {
        wx.showToast({
          title: '保存失败',
          icon: 'none',
          duration: 3000
        })
      }
    })
  }
})