import request from '@/utils/request'
import type {
  EditContactImport,
  SendEmail,
  Contact,
  EmailProvider,
  Sender,
  Variable,
  VariableTemplate,
  SubTask,
  EmailTask,
} from '@/types/index'
import type { ApiResponse } from '@/utils/request'
const baseEmailUrl = '/email/api'

// 联系人管理
export const contactApi = {
  // 新增联系人
  addContact: (data: Contact): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailContact/add`, data)
  },
  // 获取联系人详情
  getContactDetail: (id: string): Promise<ApiResponse> => {
    return request.get(`${baseEmailUrl}/emailContact/detail`, { params: { contactBizId: id } })
  },
  // 更新联系人
  updateContact: (data: Contact): Promise<ApiResponse> => {
    return request.put(`${baseEmailUrl}/emailContact/edit`, data)
  },
  // 删除联系人
  deleteContact: (id: string): Promise<ApiResponse> => {
    return request.delete(`${baseEmailUrl}/emailContact/del?contactBizId=${id}`)
  },
  // 获取联系人列表
  getContactList: (data: Contact): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailContact/page`, data)
  },
}

//
/**邮件服务商列表 */
export const emailProviderApi = {
  getEmailProviderList: (data: EmailProvider): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailProviderConfig/page`, data)
  },
}

/**发件人管理*/
export const senderApi = {
  // 新增发送人配置
  addEmailSenderConfig: (data: Sender): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailSenderConfig/add`, data)
  },
  // 删除发送人配置
  deleteEmailSenderConfig: (id: string): Promise<ApiResponse> => {
    return request.delete(`${baseEmailUrl}/emailSenderConfig/del?senderBizId=${id}`)
  },
  // 编辑发送人配置
  editEmailSenderConfig: (data: Sender): Promise<ApiResponse> => {
    return request.put(`${baseEmailUrl}/emailSenderConfig/edit`, data)
  },
  // 获取发送人配置详情
  getEmailSenderConfigDetail: (id: string): Promise<ApiResponse> => {
    return request.get(`${baseEmailUrl}/emailSenderConfig/detail`, { params: { senderBizId: id } })
  },
  // 获取发送配置列表
  getEmailSenderConfigList: (params: Sender): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailSenderConfig/page`, params)
  },
}

/**变量管理 */
export const variableApi = {
  // 分页查询变量
  getEmailVariableList: (params: Variable): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailVariable/page`, params)
  },
  // 新增变量
  addEmailVariable: (data: Variable): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailVariable/add`, data)
  },
  // 编辑变量
  editEmailVariable: (data: Variable): Promise<ApiResponse> => {
    return request.put(`${baseEmailUrl}/emailVariable/edit`, data)
  },
  // 删除变量
  deleteEmailVariable: (id: string): Promise<ApiResponse> => {
    return request.delete(`${baseEmailUrl}/emailVariable/del?variableBizId=${id}`)
  },
}
/** 变量分组管理 */
export const variableGroupApi = {
  // 新增变量分组
  addEmailVariableGroup: (data: VariableTemplate): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailVariableGroup/add`, data)
  },
  // 编辑变量分组
  editEmailVariableGroup: (data: VariableTemplate): Promise<ApiResponse> => {
    return request.put(`${baseEmailUrl}/emailVariableGroup/edit`, data)
  },
  // 删除变量分组
  deleteEmailVariableGroup: (id: string): Promise<ApiResponse> => {
    return request.delete(`${baseEmailUrl}/emailVariableGroup/del?variableGroupBizId=${id}`)
  },
  // 获取变量分组详情
  getEmailVariableGroupDetail: (id: string): Promise<ApiResponse> => {
    return request.get(`${baseEmailUrl}/emailVariableGroup/detail?variableGroupBizId=${id}`)
  },
  // 获取变量分组列表
  getEmailVariableGroupList: (params: VariableTemplate): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailVariableGroup/page`, params)
  },
}

/**
 * 导入联系人管理
 */
export const importContactApi = {
  // 新增导入联系人
  addEmailContactImport: (data: EditContactImport): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailContactImport/add`, data)
  },
  // 导入时，获取sessionId
  getEmailContactSessionId: (data: EditContactImport): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailContactImport/select/add`, data)
  },
  // 编辑导入数据
  editEmailContactImport: (data: EditContactImport): Promise<ApiResponse> => {
    return request.put(`${baseEmailUrl}/emailContactImport/edit`, data)
  },
  // 导入联系人列表查询
  getEmailContactImportList: (params: EditContactImport): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailContactImport/page`, params)
  },
  // 详情会话信息前端展示收件人，抄送人
  getEmailContactImportDetail: (id: string): Promise<ApiResponse> => {
    return request.get(`${baseEmailUrl}/emailContactImport/detail/sessionId?sessionId=${id}`)
  },
}
/**
 * 发送邮件
 */
export const sendEmailApi = {
  // 发送邮件
  sendEmail: (data: SendEmail): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/email/send`, data)
  },
  // 测试发送邮件
  testSendEmail: (data: SendEmail): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/email/test/send`, data)
  },
  // 发送任务列表查询
  getEmailTaskList: (params: SubTask): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailTaskRecipients/page`, params)
  },
  // 主线任务列表查询
  getEmailTaskMainList: (params: EmailTask): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/emailTask/page`, params)
  },
}

/**
 * 文件服务接口
 */
export const uploadApi = {
  // 上传文件
  uploadFile: (data: FormData): Promise<ApiResponse> => {
    return request.post(`${baseEmailUrl}/oss/upload`, data)
  },
}

/**
 * 根据字典类型列表获取字典项列表
 */
export const dictApi = {
  // 根据字典类型列表获取字典项列表
  getDictList: (params: string[]): Promise<ApiResponse> => {
    return request.post(`/user/api/sysDict/type/list`, { typeList: params })
  },
}

/**
 * 登录接口
 */
export const loginApi = {
  // 登录
  login: (data: LoginRequest): Promise<ApiResponse> => {
    return request.post(`/auth/auth/login`, data)
  },
}
