import { createRouter, createWebHistory } from 'vue-router'

const router = createRouter({
  history: createWebHistory(),
  routes: [
    {
      path: '/',
      redirect: '/login',
    },
    {
      path: '/compose',
      name: 'compose',
      component: () => import('../views/ComposeEmail.vue'),
    },
    {
      path: '/contacts',
      name: 'contacts',
      component: () => import('../views/ContactManagement.vue'),
    },
    {
      path: '/senders',
      name: 'senders',
      component: () => import('../views/SenderManagement.vue'),
    },
    {
      path: '/variables',
      name: 'variables',
      component: () => import('../views/VariableManagement.vue'),
    },
    {
      path: '/emails',
      name: 'emails',
      component: () => import('../views/EmailManagement.vue'),
    },
    {
      path: '/login',
      name: 'login',
      component: () => import('../views/LoginPage.vue'),
    },
  ],
})

export default router
