import { createApp } from 'vue'
import { createPinia } from 'pinia'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import '@fortawesome/fontawesome-free/css/all.min.css'
import * as ElementPlusIconsVue from '@element-plus/icons-vue'
import CommonModal from './components/CommonModal.vue'
import FileUpload from './components/FileUploadComponent.vue'
import { ElMessage, ElMessageBox } from 'element-plus'

import App from './App.vue'
import router from './router'

// 引入全部样式
import './index.css'

const app = createApp(App)
app.use(ElementPlus)
app.component('CommonModal', CommonModal)
app.component('FileUpload', FileUpload)
app.component('ElMessage', ElMessage)
app.component('ElMessageBox', ElMessageBox)

// 注册 Element Plus 图标组件
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component)
}

app.use(createPinia())
app.use(router)

app.mount('#app')
