import { createRouter, createWebHistory } from 'vue-router'

const router = createRouter({
  history: createWebHistory('/yd-email/'),
  routes: [
    {
      path: '/',
      name: 'home',
      redirect: (to) => {
        console.log('----', to.fullPath)
        // 检查用户是否已登录
        const token = localStorage.getItem('authToken')
        console.log('----', token)
        if (token) {
          // 已登录，重定向到写邮件页面
          return '/compose'
        } else {
          // 未登录，重定向到登录页面
          return '/login'
        }
      },
    },
    {
      path: '/compose',
      name: 'compose',
      component: () => import('../views/ComposeEmail.vue'),
    },
    {
      path: '/contacts',
      name: 'contacts',
      component: () => import('../views/ContactManagement.vue'),
    },
    {
      path: '/senders',
      name: 'senders',
      component: () => import('../views/SenderManagement.vue'),
    },
    {
      path: '/variables',
      name: 'variables',
      component: () => import('../views/VariableManagement.vue'),
    },
    {
      path: '/emails',
      name: 'emails',
      component: () => import('../views/EmailManagement.vue'),
    },
    {
      path: '/login',
      name: 'login',
      component: () => import('../views/LoginPage.vue'),
    },
  ],
})

// 添加路由守卫，实现条件导航
router.beforeEach((to, from, next) => {
  const token = localStorage.getItem('authToken')

  // 如果用户访问登录页且已登录，重定向到首页
  if (to.path === '/login' && token) {
    next('/compose')
    return
  }

  // 如果用户访问需要认证的页面且未登录，重定向到登录页
  const publicPages = ['/login']
  const authRequired = !publicPages.includes(to.path)

  if (authRequired && !token) {
    // 保存当前路径，登录后可跳转回来
    localStorage.setItem('redirectPath', to.fullPath)
    next('/login')
    return
  }

  next()
})

export default router
