// 分页类型
export interface Pagination<T> {
  records?: T[]
  total?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
  pageNo?: number
}

// 联系人类型
export interface Contact extends Pagination<Contact> {
  contactBizId?: string
  name?: string
  type?: string
  companyName?: string
  email?: string
  ccEmailList?: string[]
  other?: string
  appellation?: string
}

// 发件人类型
export interface Sender extends Pagination<Sender> {
  senderBizId?: string
  email?: string
  password?: string
  displayName?: string
  providerBizId?: string
  active?: number
  emailSenderConfigName?: string
  emailSenderConfigEmail?: string
}

// 变量类型
export interface Variable extends Pagination<Variable> {
  id?: string
  variableBizId?: string
  variableNameCn?: string
  variableNameEn?: string
  description?: string
}

// 变量模板类型
export interface VariableTemplate extends Pagination<VariableTemplate> {
  variableGroupBizId?: string
  groupName?: string
  description?: string
  variableBizIdList?: string[]
  variableNameEns?: string[]
}

// 邮件类型
export interface Email extends Pagination<Email> {
  id?: string
  sender?: string
  to?: string[]
  cc?: string[]
  subject?: string
  content?: string
  sendTime?: string
  status?: 'sent' | 'scheduled' | 'draft' | 'failed'
  attachments?: { name: string }[]
}

// 邮件表单类型
export interface EmailForm extends Pagination<EmailForm> {
  to: string
  cc: string
  subject: string
  content: string
  scheduleSend: boolean
  sendTime: string
}

// 忘记密码表单类型
export interface ForgotPasswordForm {
  email: string
  newPassword: string
  confirmPassword: string
}

// 导入记录类型
export interface ImportRecord {
  id: string
  to: string
  cc: string
  createdAt: string
  updatedAt: string
}

// 选择联系人时，调用接口，获取sessionId
export interface ContactSessionId {
  sessionId?: string
  apiEmailContactDtoList?: Contact[]
}

// 编辑-邮件联系人导入信息
export interface EditContactImport extends Pagination<EditContactImport> {
  receiveEmail?: string
  sessionId?: string
  source?: string
}
// 发送邮件
export interface SendEmail {
  senderBizId?: string
  recipientEmailList?: string[]
  ccEmailList?: string[]
  bccEmailList?: string[]
  subject?: string
  body?: string
}
//邮件服务商类型
export interface EmailProvider extends Pagination<EmailProvider> {
  providerBizId?: string
  providerName?: string
  smtpHost?: string
  smtpPort?: string
  sslEnabled?: number
  active?: number
  description?: string
}
