import request from '@/utils/request'
import type {
  EditContactImport,
  SendEmail,
  Contact,
  EmailProvider,
  Sender,
  Variable,
  VariableTemplate,
} from '@/types/index'
import type { ApiResponse } from '@/utils/request'

// 联系人管理
export const contactApi = {
  // 新增联系人
  addContact: (data: Contact): Promise<ApiResponse> => {
    return request.post('/emailContact/add', data)
  },
  // 获取联系人详情
  getContactDetail: (id: string): Promise<ApiResponse> => {
    return request.get('/emailContact/detail', { params: { contactBizId: id } })
  },
  // 更新联系人
  updateContact: (data: Contact): Promise<ApiResponse> => {
    return request.put('/emailContact/edit', data)
  },
  // 删除联系人
  deleteContact: (id: string): Promise<ApiResponse> => {
    return request.delete('/emailContact/del?contactBizId=' + id)
  },
  // 获取联系人列表
  getContactList: (data: Contact): Promise<ApiResponse> => {
    return request.post('/emailContact/page', data)
  },
}

//
/**邮件服务商列表 */
export const emailProviderApi = {
  getEmailProviderList: (data: EmailProvider): Promise<ApiResponse> => {
    return request.post('/emailProviderConfig/page', data)
  },
}

/**发件人管理*/
export const senderApi = {
  // 新增发送人配置
  addEmailSenderConfig: (data: Sender): Promise<ApiResponse> => {
    return request.post('/emailSenderConfig/add', data)
  },
  // 删除发送人配置
  deleteEmailSenderConfig: (id: string): Promise<ApiResponse> => {
    return request.delete('/emailSenderConfig/del?senderBizId=' + id)
  },
  // 编辑发送人配置
  editEmailSenderConfig: (data: Sender): Promise<ApiResponse> => {
    return request.put('/emailSenderConfig/edit', data)
  },
  // 获取发送人配置详情
  getEmailSenderConfigDetail: (id: string): Promise<ApiResponse> => {
    return request.get('/emailSenderConfig/detail', { params: { senderBizId: id } })
  },
  // 获取发送配置列表
  getEmailSenderConfigList: (params: Sender): Promise<ApiResponse> => {
    return request.post('/emailSenderConfig/page', params)
  },
}

/**变量管理 */
export const variableApi = {
  // 分页查询变量
  getEmailVariableList: (params: Variable): Promise<ApiResponse> => {
    return request.post('/emailVariable/page', params)
  },
  // 新增变量
  addEmailVariable: (data: Variable): Promise<ApiResponse> => {
    return request.post('/emailVariable/add', data)
  },
  // 编辑变量
  editEmailVariable: (data: Variable): Promise<ApiResponse> => {
    return request.put('/emailVariable/edit', data)
  },
  // 删除变量
  deleteEmailVariable: (id: string): Promise<ApiResponse> => {
    return request.delete('/emailVariable/del?variableBizId=' + id)
  },
}
/** 变量分组管理 */
export const variableGroupApi = {
  // 新增变量分组
  addEmailVariableGroup: (data: VariableTemplate): Promise<ApiResponse> => {
    return request.post('/emailVariableGroup/add', data)
  },
  // 编辑变量分组
  editEmailVariableGroup: (data: VariableTemplate): Promise<ApiResponse> => {
    return request.put('/emailVariableGroup/edit', data)
  },
  // 删除变量分组
  deleteEmailVariableGroup: (id: string): Promise<ApiResponse> => {
    return request.delete('/emailVariableGroup/del?variableGroupBizId=' + id)
  },
  // 获取变量分组详情
  getEmailVariableGroupDetail: (id: string): Promise<ApiResponse> => {
    return request.get('/emailVariableGroup/detail?variableGroupBizId=' + id)
  },
  // 获取变量分组列表
  getEmailVariableGroupList: (params: VariableTemplate): Promise<ApiResponse> => {
    return request.post('/emailVariableGroup/page', params)
  },
}

/**
 * 导入联系人管理
 */
export const importContactApi = {
  // 新增导入联系人
  addEmailContactImport: (data: EditContactImport): Promise<ApiResponse> => {
    return request.post('/emailContactImport/add', data)
  },
  // 导入时，获取sessionId
  getEmailContactSessionId: (data: EditContactImport): Promise<ApiResponse> => {
    return request.post('/emailContactImport/select/add', data)
  },
  // 编辑导入数据
  editEmailContactImport: (data: EditContactImport): Promise<ApiResponse> => {
    return request.put('/emailContactImport/edit', data)
  },
  // 导入联系人列表查询
  getEmailContactImportList: (params: EditContactImport): Promise<ApiResponse> => {
    return request.post('/emailContactImport/page', params)
  },
}
/**
 * 发送邮件
 */
export const sendEmailApi = {
  // 发送邮件
  sendEmail: (data: SendEmail): Promise<ApiResponse> => {
    return request.post('/email/send', data)
  },
  // 测试发送邮件
  testSendEmail: (data: SendEmail): Promise<ApiResponse> => {
    return request.post('/email/test/send', data)
  },
}
