// 联系人类型
export interface Contact {
  id: string
  name: string
  title: string
  company: string
  email: string
  ccEmail: string
  other: string
}

// 发件人类型
export interface Sender {
  id: string
  email: string
  password: string
  smtpServer: string
  smtpPort: string
}

// 变量类型
export interface Variable {
  id: string
  name: string
  key: string
  description: string
}

// 变量模板类型
export interface VariableTemplate {
  id: string
  name: string
  description: string
  variableIds: string[]
}

// 邮件类型
export interface Email {
  id: string
  sender: string
  to: string
  cc: string
  subject: string
  content: string
  sendTime: string
  status: 'sent' | 'scheduled' | 'draft' | 'failed'
  attachments?: { name: string }[]
}

// 邮件表单类型
export interface EmailForm {
  to: string
  cc: string
  subject: string
  content: string
  scheduleSend: boolean
  sendTime: string
}

// 忘记密码表单类型
export interface ForgotPasswordForm {
  email: string
  newPassword: string
  confirmPassword: string
}
