package com.yd.rmi.ali.mail.service.impl;
import com.yd.rmi.ali.mail.service.MailService;
import com.yd.rmi.ali.mail.vo.SendMailRequestVO;
import com.yd.rmi.ali.mailinterf.service.AliMailInterfService;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.util.CommonUtil;
import com.yd.util.SpringContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("mailService")
public class MailServiceImpl implements MailService {
	@Autowired
	private AliMailInterfService aliMailInterfService;
	@Autowired
	private SystemConfigService systemConfigService;
	@Override
	public void sendMail(SendMailRequestVO sendMailRequestVO) {
		String sendType = sendMailRequestVO.getSendType();
		String toAddress = sendMailRequestVO.getToAddress();
		String[] ccAddresses = sendMailRequestVO.getCcAddresses();
		String subject = sendMailRequestVO.getSubject();
		String messageHtml = sendMailRequestVO.getMessageHtml();
		String messageText = sendMailRequestVO.getMessageText();
		String templateName = sendMailRequestVO.getTemplateName();
		String receiversName = sendMailRequestVO.getReceiversName();
		List<String> attachmentFiles = sendMailRequestVO.getAttachmentFiles();
		String imageFile = sendMailRequestVO.getImageFile();
		try {
			if("1".equals(sendType)){
				aliMailInterfService.singleSend(toAddress, subject, messageHtml, messageText);
			}else if("2".equals(sendType)){
				aliMailInterfService.batchSend(templateName, receiversName);
			}else if("3".equals(sendType)){
				aliMailInterfService.smtpSend(toAddress,ccAddresses, subject, messageText, attachmentFiles, imageFile);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void sysWarning(String warningSubject,String warningMessage) {
		String toAddress = "wenyang.yan@ydinsurance.cn";
		List<String> ccList = systemConfigService.getListConfigValue("SysWarningCCAddress");
		String[] ccAddresses = new String[ccList.size()];
		ccList.toArray(ccAddresses);
		String subject = "【"+ SpringContextUtil.getEnvironmentName()+"环境】"+warningSubject;
		String messageText = CommonUtil.currentIP()+"	"+warningMessage;
		String imageFile = null;
		try {
			aliMailInterfService.smtpSend(toAddress, ccAddresses,subject, messageText, null, imageFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void sysNotify(String toAddress, String[] ccAddress, String notifySubject, String notifyMessage) {
		try {
			aliMailInterfService.smtpSend(toAddress, ccAddress, notifySubject, notifyMessage, null, null);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void sysException(String warningSubject, String warningMessage) {
//		if("prod".equals(SpringContextUtil.getActiveProfile())){
		String toAddress = "wenyang.yan@ydinsurance.cn";//"simon.cheng@autogeneral.cn";
		List<String> ccList = systemConfigService.getListConfigValue("SysWarningCCAddress");
		String[] ccAddresses = new String[ccList.size()];
		ccList.toArray(ccAddresses);
		String subject = "【"+SpringContextUtil.getEnvironmentName()+"环境】"+warningSubject;
		String messageText = CommonUtil.currentIP()+"	"+warningMessage;
		String imageFile = null;
		try {
			aliMailInterfService.smtpSend(toAddress, ccAddresses,subject, messageText, null, imageFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
//		}
	}
}
