package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_file_upload
 * @author 
 */
@Data
public class AclFileUpload implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 1=从业人员practioner表, 2=员工user表,  3=客户customer表, 4=渠道客户channel表 
     */
    private Integer targetType;

    /**
     * 对应每种功能表的 id
     */
    private Long targetId;

    /**
     * 对应每种功能表代表编号
     */
    private String targetNo;

    /**
     * 文件用途 1=头像 2=生活照 3=证照 4=毕业证书 5=营业登记证 6.咨询定制方案 7.客户身份证正面照片 8.客户身份证反面照片9.个人微信二维码
     */
    private Integer targetUseFor;

    /**
     * 文件排列顺序
     */
    private Integer targetSeq;

    /**
     * 1.PDF 2.DOC 3.PPT 4.JPEG
     */
    private String fileType;

    /**
     * 檔案名称
     */
    private String fileName;

    /**
     * 檔案路径
     */
    private String filePath;

    /**
     * 备注
     */
    private String remark;

    /**
     * 檔案大小
     */
    private String fileSize;

    /**
     * OSS KEY
     */
    private String ossKey;

    /**
     * 是否有效/展示 0=N0, 1=Yes
     */
    private Integer isActive;

    private Long orderId;

    /**
     * 上传时间
     */
    private Date uploadedAt;

    private Long uploadedBy;

    private static final long serialVersionUID = 1L;
}