package com.yd.dal.service.meta.impl;

import com.yd.dal.entity.meta.MdDropOptions;
import com.yd.dal.entity.meta.OptionsEGolden;
import com.yd.dal.mapper.meta.MdDropOptionsMapper;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;

@Service("mdDropOptionsDALService")
public class MdDropOptionsDALServiceImpl implements MdDropOptionsDALService {

    @Resource
    private MdDropOptionsMapper mdDropOptionsMapper;

    @Override
    public List<MdDropOptions> findByDropMasterId(long dropMasterId) {
        MdDropOptions info = new MdDropOptions();
        info.setDropMasterId(dropMasterId);
        return mdDropOptionsMapper.selectByObj(info);
    }

    @Override
    public MdDropOptions findByDropOptionId(Long dropOptionId) {
        return mdDropOptionsMapper.selectByPrimaryKey(dropOptionId);
    }

    @Override
    public List<MdDropOptions> findByDropMasterCode(String dropMasterCode) {
        return mdDropOptionsMapper.findByDropMasterCode(dropMasterCode);
    }
    @Override
    public MdDropOptions findById(Long trackStatusId) {
        return mdDropOptionsMapper.selectByPrimaryKey(trackStatusId);
    }

    @Override
    public List<MdDropOptions> findByMasterCode(String masterCode) {
        return mdDropOptionsMapper.findByMasterCode(masterCode);
    }

    @Override
    public List<MdDropOptions> findByMasterCodeAndOrderId(String masterCode, int orderId) {
        return mdDropOptionsMapper.findByMasterCodeAndOrderId(masterCode,orderId);
    }

    @Override
    public MdDropOptions selectByMasterCodeAndOptionsCode(String masterCode, String optionsCode) {
        return mdDropOptionsMapper.selectByMasterCodeAndOptionsCode(masterCode, optionsCode);
    }
    @Override
    public List<MdDropOptions> findByMasterCodeAndOptionsCode(String masterCode, String optionsCode) {
        return mdDropOptionsMapper.findByMasterCodeAndOptionsCode(masterCode,optionsCode);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<OptionsEGolden> findByMasterIdsE(List<Integer> materIds) {
        return mdDropOptionsMapper.findByMasterIdsE(materIds);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<OptionsEGolden> findAllTitleEG() {
        return mdDropOptionsMapper.findAllTitleEG();
    }
}
