package com.yd.dal.entity.order;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Purchase Order 訂單
 */
public class PoOrder {
    private static final long serialVersionUID = 1L;
    /**
     * serial id
     */
    private Long id;

    /**
     * 规则层级 1-insurer 2-product 3-plan
     */
    private Integer configLevel;

    /**
     * 产品ID, FK ag_product.id
     */
    private Long productId;

    /**
     * 方案ID
     */
    private Long planId;

    /**
     * order#
     */
    private String orderNo;

    /**
     * order datetime 0000-00-00 00:00:00
     */
    private Date orderDate;

    /**
     * order price
     */
    private BigDecimal orderPrice;

    /**
     * 报价单ag_po_quotation.id
     */
    private Long quotationId;

    /**
     * 报价单ag_po_quotation.quote_no
     */
    private Long quoteNo;

    /**
     * ag_product_category.id,id = 3车险
     */
    private Long productCategoryId;

    /**
     * 目的地
     */
    private String destination;

    /**
     * FK ag_md_continent.id
     */
    private Long destinationContinentId;

    /**
     * FK ag_md_region.id
     */
    private Long destinationRegionId;

    /**
     * FK ag_md_country.id
     */
    private Long destinationCountryId;

    /**
     * 起保日期
     */
    private Date effectiveStartDate;

    /**
     * 终保日期
     */
    private Date effectiveEndDate;

    /**
     * 1-365 days
     */
    private Integer coverLength;

    private Integer coverAdultQty;

    private Integer coverUnderageQty;

    /**
     * 1.Wechat 2.AliPay 3.Bank
     */
    private Long paymentMethodId;

    /**
     * pay url
     */
    private String payUrl;

    /**
     * 统一支付落地页1：H5，2：group
     */
    private Integer payFrom;

    private String insurerPdfUrl;

    /**
     * 0=No, 1=Yes
     */
    private Integer isMsgSent;

    /**
     * 0=无车船税, 1=有车船税
     */
    private Integer isCarTax;

    /**
     * 银盾企业增值税缺省为0，小数
     */
    private BigDecimal ydValueAddedTax;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission银盾来佣佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 银盾来佣佣金
     */
    private BigDecimal commissionAmount;

    /**
     * 公告佣金率存百分值
     */
    private BigDecimal fycRate;

    /**
     * 公告佣金
     */
    private BigDecimal fycAmount;

    /**
     * B2C Rate存百分值
     */
    private BigDecimal b2cRate;

    /**
     * FK ag_acl_channel_referral_rate个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * 最终个人佣金率 = 银盾来佣率 * (1 + yd_value_added_tax) * 银盾公告佣金率 * 个人职级佣金率
     */
    private BigDecimal referralRate;

    /**
     * 最终个人佣金 = order_price / (1 + yd_value_added_tax) * 银盾来佣率 * 银盾公告佣金率 * 个人职级佣金率
     */
    private BigDecimal referralAmount;

    /**
     * FK ag_order_policy.id
     */
    private Long policyId;

    private String policyNo;

    /**
     * 市场活动
     */
    private String mktCampaign;

    /**
     * 市场活动任务
     */
    private String mktTask;

    /**
     * 0=No, 1=Yes
     */
    private Integer isConverted;

    /**
     * 1=open 2=confirm 3=completed 4=cancelled 5=overdue 9=error
     */
    private Integer status;

    /**
     * 1=pending 2=paid 3=received 9=error
     */
    private Integer paymentStatus;

    /**
     * flag
     */
    private String flag;

    private Long customerId;

    /**
     * 分享人customer_id
     */
    private Long referralCustomerId;

    /**
     * 分享码
     */
    private String shareCode;

    private Long insurerId;

    /**
     * 数据来源
     */
    private String dataSource;

    /**
     * 有无社保（1-有；0-无）
     */
    private Integer isSocialInsured;

    /**
     * 保障计划 1=终身 2=保障至70岁 3=保障至80岁
     */
    private Integer coverTerm;

    /**
     * 缴费期限
     */
    private Integer paymentTerm;

    /**
     * Y=年, M=月, D=日, A=岁
     */
    private String paymentTermUnit;

    /**
     * 缴费间隔; -1-不定期交、0-一次交清、1-月交、3-季交、6-半年交、12-年交
     */
    private Integer payInterval;

    /**
     * ERP系统是否可见 1-可见 2-不可见
     */
    private String viewFlag;

    /**
     * 动态字段A
     */
    private String dynamicFieldA;

    /**
     * 动态字段B
     */
    private String dynamicFieldB;

    private String dynamicFieldC;

    /**
     * 动态字段D
     */
    private String dynamicFieldD;

    /**
     * 驾乘险车牌号码
     */
    private String plateNo;

    /**
     * group团单添加订单说明
     */
    private String memo;

    /**
     * 试算参数报文
     */
    private String productTableRequestJson;

    /**
     * 核定座位数
     */
    private Integer verifiedSeats;

    /**
     * 驾乘险车架号
     */
    private String frameNo;

    /**
     * 保障标的物所在省份, FK ag_md_province.id
     */
    private Long subjectProvinceId;

    /**
     * 保障标的物所在城市, FK ag_md_city.id
     */
    private Long subjectCityId;

    /**
     * 保障标的物所在详细地址
     */
    private String subjectAddress;

    /**
     * 民宿房间数
     */
    private String roomQty;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * 修改人
     */
    private Long updatedBy;

    /**
     * 营销投放渠道来源 hmsr
     */
    private String sourceChannel;

    /**
     * 营销投放产品名 hmpl
     */
    private String sourcePlanName;

    /**
     * 营销投放推送日期 hmkw
     */
    private String sourcePublishdate;

    /**
     * 营销投放推送文章或其他 hmci
     */
    private String sourceArticle;

    /**
     * 访问IP
     */
    private String ipAddress;

    /**
     * 访问IP所属的地域
     */
    private String ipRegion;

    /**
     * 续保去年的order id
     */
    private Long renewOrderId;

    /**
     * 0=No, 1=Yes 是否已续保完成? 会针对去年订单做异动
     */
    private Integer isRenewComplete;

    /**
     * 是否银盾收保费 0=No, 1=Yes
     */
    private Integer isPayToYd;

    /**
     * 保险费过期未付选择 保险单借款垫缴:Y中止合同:N
     */
    private String autoPayFlag;

    private Long commissionCheckId;
    private String commissionCheckStatus;
    private Date commissionCheckAt;
    private Long commissionCheckBy;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getConfigLevel() {
        return configLevel;
    }

    public void setConfigLevel(Integer configLevel) {
        this.configLevel = configLevel;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public BigDecimal getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    public Long getQuotationId() {
        return quotationId;
    }

    public void setQuotationId(Long quotationId) {
        this.quotationId = quotationId;
    }

    public Long getQuoteNo() {
        return quoteNo;
    }

    public void setQuoteNo(Long quoteNo) {
        this.quoteNo = quoteNo;
    }

    public Long getProductCategoryId() {
        return productCategoryId;
    }

    public void setProductCategoryId(Long productCategoryId) {
        this.productCategoryId = productCategoryId;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Long getDestinationContinentId() {
        return destinationContinentId;
    }

    public void setDestinationContinentId(Long destinationContinentId) {
        this.destinationContinentId = destinationContinentId;
    }

    public Long getDestinationRegionId() {
        return destinationRegionId;
    }

    public void setDestinationRegionId(Long destinationRegionId) {
        this.destinationRegionId = destinationRegionId;
    }

    public Long getDestinationCountryId() {
        return destinationCountryId;
    }

    public void setDestinationCountryId(Long destinationCountryId) {
        this.destinationCountryId = destinationCountryId;
    }

    public Date getEffectiveStartDate() {
        return effectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getEffectiveEndDate() {
        return effectiveEndDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public Integer getCoverLength() {
        return coverLength;
    }

    public void setCoverLength(Integer coverLength) {
        this.coverLength = coverLength;
    }

    public Integer getCoverAdultQty() {
        return coverAdultQty;
    }

    public void setCoverAdultQty(Integer coverAdultQty) {
        this.coverAdultQty = coverAdultQty;
    }

    public Integer getCoverUnderageQty() {
        return coverUnderageQty;
    }

    public void setCoverUnderageQty(Integer coverUnderageQty) {
        this.coverUnderageQty = coverUnderageQty;
    }

    public Long getPaymentMethodId() {
        return paymentMethodId;
    }

    public void setPaymentMethodId(Long paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public void setPayUrl(String payUrl) {
        this.payUrl = payUrl;
    }

    public Integer getPayFrom() {
        return payFrom;
    }

    public void setPayFrom(Integer payFrom) {
        this.payFrom = payFrom;
    }

    public String getInsurerPdfUrl() {
        return insurerPdfUrl;
    }

    public void setInsurerPdfUrl(String insurerPdfUrl) {
        this.insurerPdfUrl = insurerPdfUrl;
    }

    public Integer getIsMsgSent() {
        return isMsgSent;
    }

    public void setIsMsgSent(Integer isMsgSent) {
        this.isMsgSent = isMsgSent;
    }

    public Integer getIsCarTax() {
        return isCarTax;
    }

    public void setIsCarTax(Integer isCarTax) {
        this.isCarTax = isCarTax;
    }

    public BigDecimal getYdValueAddedTax() {
        return ydValueAddedTax;
    }

    public void setYdValueAddedTax(BigDecimal ydValueAddedTax) {
        this.ydValueAddedTax = ydValueAddedTax;
    }

    public BigDecimal getCommissionRate() {
        return commissionRate;
    }

    public void setCommissionRate(BigDecimal commissionRate) {
        this.commissionRate = commissionRate;
    }

    public BigDecimal getCommissionAmount() {
        return commissionAmount;
    }

    public void setCommissionAmount(BigDecimal commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    public BigDecimal getFycRate() {
        return fycRate;
    }

    public void setFycRate(BigDecimal fycRate) {
        this.fycRate = fycRate;
    }

    public BigDecimal getFycAmount() {
        return fycAmount;
    }

    public void setFycAmount(BigDecimal fycAmount) {
        this.fycAmount = fycAmount;
    }

    public BigDecimal getB2cRate() {
        return b2cRate;
    }

    public void setB2cRate(BigDecimal b2cRate) {
        this.b2cRate = b2cRate;
    }

    public BigDecimal getGradeCommissionRate() {
        return gradeCommissionRate;
    }

    public void setGradeCommissionRate(BigDecimal gradeCommissionRate) {
        this.gradeCommissionRate = gradeCommissionRate;
    }

    public BigDecimal getReferralRate() {
        return referralRate;
    }

    public void setReferralRate(BigDecimal referralRate) {
        this.referralRate = referralRate;
    }

    public BigDecimal getReferralAmount() {
        return referralAmount;
    }

    public void setReferralAmount(BigDecimal referralAmount) {
        this.referralAmount = referralAmount;
    }

    public Long getPolicyId() {
        return policyId;
    }

    public void setPolicyId(Long policyId) {
        this.policyId = policyId;
    }

    public String getPolicyNo() {
        return policyNo;
    }

    public void setPolicyNo(String policyNo) {
        this.policyNo = policyNo;
    }

    public String getMktCampaign() {
        return mktCampaign;
    }

    public void setMktCampaign(String mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public String getMktTask() {
        return mktTask;
    }

    public void setMktTask(String mktTask) {
        this.mktTask = mktTask;
    }

    public Integer getIsConverted() {
        return isConverted;
    }

    public void setIsConverted(Integer isConverted) {
        this.isConverted = isConverted;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getReferralCustomerId() {
        return referralCustomerId;
    }

    public void setReferralCustomerId(Long referralCustomerId) {
        this.referralCustomerId = referralCustomerId;
    }

    public String getShareCode() {
        return shareCode;
    }

    public void setShareCode(String shareCode) {
        this.shareCode = shareCode;
    }

    public Long getInsurerId() {
        return insurerId;
    }

    public void setInsurerId(Long insurerId) {
        this.insurerId = insurerId;
    }

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public Integer getIsSocialInsured() {
        return isSocialInsured;
    }

    public void setIsSocialInsured(Integer isSocialInsured) {
        this.isSocialInsured = isSocialInsured;
    }

    public Integer getCoverTerm() {
        return coverTerm;
    }

    public void setCoverTerm(Integer coverTerm) {
        this.coverTerm = coverTerm;
    }

    public Integer getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(Integer paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public String getPaymentTermUnit() {
        return paymentTermUnit;
    }

    public void setPaymentTermUnit(String paymentTermUnit) {
        this.paymentTermUnit = paymentTermUnit;
    }

    public Integer getPayInterval() {
        return payInterval;
    }

    public void setPayInterval(Integer payInterval) {
        this.payInterval = payInterval;
    }

    public String getViewFlag() {
        return viewFlag;
    }

    public void setViewFlag(String viewFlag) {
        this.viewFlag = viewFlag;
    }

    public String getDynamicFieldA() {
        return dynamicFieldA;
    }

    public void setDynamicFieldA(String dynamicFieldA) {
        this.dynamicFieldA = dynamicFieldA;
    }

    public String getDynamicFieldB() {
        return dynamicFieldB;
    }

    public void setDynamicFieldB(String dynamicFieldB) {
        this.dynamicFieldB = dynamicFieldB;
    }

    public String getDynamicFieldC() {
        return dynamicFieldC;
    }

    public void setDynamicFieldC(String dynamicFieldC) {
        this.dynamicFieldC = dynamicFieldC;
    }

    public String getDynamicFieldD() {
        return dynamicFieldD;
    }

    public void setDynamicFieldD(String dynamicFieldD) {
        this.dynamicFieldD = dynamicFieldD;
    }

    public String getPlateNo() {
        return plateNo;
    }

    public void setPlateNo(String plateNo) {
        this.plateNo = plateNo;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getProductTableRequestJson() {
        return productTableRequestJson;
    }

    public void setProductTableRequestJson(String productTableRequestJson) {
        this.productTableRequestJson = productTableRequestJson;
    }

    public Integer getVerifiedSeats() {
        return verifiedSeats;
    }

    public void setVerifiedSeats(Integer verifiedSeats) {
        this.verifiedSeats = verifiedSeats;
    }

    public String getFrameNo() {
        return frameNo;
    }

    public void setFrameNo(String frameNo) {
        this.frameNo = frameNo;
    }

    public Long getSubjectProvinceId() {
        return subjectProvinceId;
    }

    public void setSubjectProvinceId(Long subjectProvinceId) {
        this.subjectProvinceId = subjectProvinceId;
    }

    public Long getSubjectCityId() {
        return subjectCityId;
    }

    public void setSubjectCityId(Long subjectCityId) {
        this.subjectCityId = subjectCityId;
    }

    public String getSubjectAddress() {
        return subjectAddress;
    }

    public void setSubjectAddress(String subjectAddress) {
        this.subjectAddress = subjectAddress;
    }

    public String getRoomQty() {
        return roomQty;
    }

    public void setRoomQty(String roomQty) {
        this.roomQty = roomQty;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Long getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    public String getSourceChannel() {
        return sourceChannel;
    }

    public void setSourceChannel(String sourceChannel) {
        this.sourceChannel = sourceChannel;
    }

    public String getSourcePlanName() {
        return sourcePlanName;
    }

    public void setSourcePlanName(String sourcePlanName) {
        this.sourcePlanName = sourcePlanName;
    }

    public String getSourcePublishdate() {
        return sourcePublishdate;
    }

    public void setSourcePublishdate(String sourcePublishdate) {
        this.sourcePublishdate = sourcePublishdate;
    }

    public String getSourceArticle() {
        return sourceArticle;
    }

    public void setSourceArticle(String sourceArticle) {
        this.sourceArticle = sourceArticle;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpRegion() {
        return ipRegion;
    }

    public void setIpRegion(String ipRegion) {
        this.ipRegion = ipRegion;
    }

    public Long getRenewOrderId() {
        return renewOrderId;
    }

    public void setRenewOrderId(Long renewOrderId) {
        this.renewOrderId = renewOrderId;
    }

    public Integer getIsRenewComplete() {
        return isRenewComplete;
    }

    public void setIsRenewComplete(Integer isRenewComplete) {
        this.isRenewComplete = isRenewComplete;
    }

    public Integer getIsPayToYd() {
        return isPayToYd;
    }

    public void setIsPayToYd(Integer isPayToYd) {
        this.isPayToYd = isPayToYd;
    }

    public String getAutoPayFlag() {
        return autoPayFlag;
    }

    public void setAutoPayFlag(String autoPayFlag) {
        this.autoPayFlag = autoPayFlag;
    }

    public Long getCommissionCheckId() {
        return commissionCheckId;
    }

    public void setCommissionCheckId(Long commissionCheckId) {
        this.commissionCheckId = commissionCheckId;
    }

    public String getCommissionCheckStatus() {
        return commissionCheckStatus;
    }

    public void setCommissionCheckStatus(String commissionCheckStatus) {
        this.commissionCheckStatus = commissionCheckStatus;
    }

    public Date getCommissionCheckAt() {
        return commissionCheckAt;
    }

    public void setCommissionCheckAt(Date commissionCheckAt) {
        this.commissionCheckAt = commissionCheckAt;
    }

    public Long getCommissionCheckBy() {
        return commissionCheckBy;
    }

    public void setCommissionCheckBy(Long commissionCheckBy) {
        this.commissionCheckBy = commissionCheckBy;
    }
}