package com.yd.api.customer;

import com.yd.api.customer.service.CustomerTrackVideoService;
import com.yd.api.customer.vo.trackvideo.AddCustomerTrackVideoRequestVO;
import com.yd.api.customer.vo.trackvideo.QueryDetailsByIdResponseVO;
import com.yd.api.customer.vo.trackvideo.QueryTrackListRequestVO;
import com.yd.api.customer.vo.trackvideo.QueryTrackListResponseVO;
import com.yd.api.result.CommonResultResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("/customerTrackVideo")
public class CustomerTrackVideoController {
	
	@Autowired
	private CustomerTrackVideoService customerTrackVideoService;

	/**
	 * 保存
	 * @param requestVO
	 * @param dataFile
	 * @return
	 */
	@RequestMapping("/add")
	public Object add(AddCustomerTrackVideoRequestVO requestVO,
					  @RequestParam(value = "dataFile") MultipartFile dataFile){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = customerTrackVideoService.add(requestVO, dataFile);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	@RequestMapping("/queryTrackList")
	public Object queryTrackList(@RequestBody QueryTrackListRequestVO requestVO){
		JsonResult result = new JsonResult();
		QueryTrackListResponseVO responseVO = customerTrackVideoService.queryTrackList(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	@RequestMapping("/queryDetailsById/{id}")
	public Object queryDetailsById(@PathVariable Long id){
		JsonResult result = new JsonResult();
		QueryDetailsByIdResponseVO responseVO = customerTrackVideoService.queryDetailsById(id);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

}