package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.rank.AclCustomerFortuneStatistics;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerInfoForAchievement;
import com.yd.api.practitioner.vo.setting.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclCustomerLog;
import com.yd.dal.entity.customer.AclFileUpload;
import com.yd.dal.entity.customer.CustomerFileUpload;
import com.yd.dal.entity.practitioner.*;
import com.yd.dal.entity.tencent.TenInterfRecord;
import com.yd.dal.service.customer.AclCustomerLogDALService;
import com.yd.dal.service.customer.AclFileUploadDALService;
import com.yd.dal.service.meta.MdCodeDALService;
import com.yd.dal.service.practitioner.PractitionerDALService;
import com.yd.dal.service.practitioner.PractitionerSubordinateDALService;
import com.yd.dal.service.tencent.TenInterfRecordDALService;
import com.yd.dal.service.transaction.TranLogDALService;
import com.yd.rmi.ali.oss.service.OssService;
import com.yd.rmi.tencent.wechat.service.WechatService;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.util.CommonUtil;
import com.yd.util.HttpUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.google.common.base.Strings;
import org.springframework.transaction.annotation.Transactional;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;

@Service("practitionerService")
public class PractitionerServiceImpl implements com.yd.api.practitioner.service.PractitionerService {

    @Autowired
    private PractitionerDALService practitionerDALService;
    @Autowired
    private MdCodeDALService mdCodeDALService;
    @Autowired
    private AclFileUploadDALService aclFileUploadDALService;
    @Autowired
    private PractitionerSubordinateDALService practitionerSubordinateDALService;
    @Autowired
    private AclCustomerLogDALService aclCustomerLogDALService;
    @Autowired
    private OssService ossService;
    @Autowired
    private WechatService wechatService;

    @Override
    public PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO) {
        PractitionerLoginResponseVO responseVO = new PractitionerLoginResponseVO();
        String mobileNo = requestVO.getMobileNo();
        //1、校验入参，电话号码不能为空
        if (Strings.isNullOrEmpty(mobileNo)) {
            String[] params = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", params)));
            return responseVO;
        }
        //2、检查是否在ag_acl_customer表中存在该用户，如果不存在就注册，然后直接抛错，该用户未注册为经纪人
        PractitionerInfo practitionerInfo = practitionerDALService.findPractitionerInfoByLogin(mobileNo);
        if(practitionerInfo != null){
            Long practitionerType = practitionerInfo.getPractitionerType();
            //处理特殊人员
            boolean isSpecial = false;
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                isSpecial = mobileSpecials.contains(mobileNo);
            }
            if(28L == practitionerType || isSpecial){//只有寿险的经纪人和注册为经纪人的员工才能登录
                Long practitionerId = practitionerInfo.getPractitionerId();
                Long customerId = practitionerInfo.getCustomerId();
                com.yd.api.practitioner.vo.login.PractitionerBasicInfo basicInfo = new com.yd.api.practitioner.vo.login.PractitionerBasicInfo();
                BeanUtils.copyProperties(practitionerInfo,basicInfo);
                //获取头像
                Integer targetType = 1, targetUseFor = 1;
                CustomerFileUpload fileUpload = aclFileUploadDALService.findFilePathInfo(targetType,targetUseFor,practitionerId);
                String imagePath = (fileUpload != null) ? fileUpload.getFilePath() : null;
                basicInfo.setHeadImagePath(imagePath);
                //获取体系信息
                Long subordinateId = practitionerInfo.getSubordinateId();
                if(subordinateId != null){
                    PractitionerSubordinateInfo subordinateInfo = practitionerSubordinateDALService.findSubordinateInfo(subordinateId);
                    if(subordinateInfo != null){
                        basicInfo.setSubordinateName(subordinateInfo.getSubordinateName());
                        basicInfo.setSubordinateLeader(subordinateInfo.getSubordinateLeader());
                    }
                }
                //获取用户的登录次数
                List<AclCustomerLog> customerLogList = aclCustomerLogDALService.findLogInfoByCustomerId(customerId);
                int logTimes = (customerLogList.isEmpty()) ? 0 : customerLogList.size();
                //保存用户的登录记录
                aclCustomerLogDALService.saveCustomerLog(customerId,2);
                responseVO.setCustomerId(customerId);
                responseVO.setPractitionerId(practitionerId);
                responseVO.setPractitionerBasicInfo(basicInfo);
                responseVO.setLoginTimes(logTimes);
                responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            }
        }else{
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001")));
        }
        return responseVO;
    }

    @Override
    public PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO) {
        PractitionerRankResponseVO responseVO = new PractitionerRankResponseVO();
        String mobileNo = requestVO.getMobileNo();
        Integer type = requestVO.getType();
        Integer time = requestVO.getTime();
        Integer platform = requestVO.getPlatform();
        type = (type == null) ? 1 : type;//默认：保费
        time = (time == null) ? 1 : time;//默认：本月
        platform = (platform == null) ? 1 : platform;
        if(!Strings.isNullOrEmpty(mobileNo)){
            //查询该手机号码的经纪人id，是否存在
            PractitionerBasicInfo practitionerBasicInfo = getPractitionerBasicInfo(mobileNo,platform);
            if(practitionerBasicInfo != null){
                String practitionerId = practitionerBasicInfo.getPractitionerId();
                if(!Strings.isNullOrEmpty(practitionerId)){
                    List<PractitionerRankInfo> rankInfoList = getPractitionerRankInfo(time,platform);
                    //按照指定类型排序
                    getPractitionerRankResult(responseVO,rankInfoList,type,practitionerId);
                    responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else{
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001"))); //该经纪人不存在
            }
        }else{
            String [] param = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", param)));
        }
        return responseVO;
    }

    private List<PractitionerRankInfo> getPractitionerRankInfo(Integer time, Integer platform) {
        List<PractitionerRankInfo> rankInfoList;
        if(platform == 1){
            Long practitionerTypeId = 28L;
            rankInfoList = practitionerDALService.getPractitionerRankInfoForOnline(time,practitionerTypeId);
            //特殊人员处理
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                List<PractitionerRankInfo> rankInfoListSpecials = practitionerDALService.getPractitionerRankInfoForSpecials(mobileSpecials,time);
                rankInfoList.addAll(rankInfoListSpecials);
            }
        }else{
            rankInfoList = practitionerDALService.getPractitionerRankInfoForOffline(time);
        }
        return rankInfoList;
    }

    private PractitionerBasicInfo getPractitionerBasicInfo(String mobileNo, Integer platform) {
        PractitionerBasicInfo practitionerBasicInfo;
        if(platform == 1){
            practitionerBasicInfo = practitionerDALService.getPractitionerBasicInfoForOnline(mobileNo);
            if(practitionerBasicInfo != null){
                Long practitionerId = practitionerBasicInfo.getPractitionerIdForOnline();
                if(practitionerId != null){
                    practitionerBasicInfo.setPractitionerId(practitionerId.toString());
                }
            }
        }else{
            practitionerBasicInfo = practitionerDALService.getPractitionerBasicInfoForOffline(mobileNo);
        }
        return practitionerBasicInfo;
    }

    private void getPractitionerRankResult(PractitionerRankResponseVO responseVO, List<PractitionerRankInfo> rankInfoList, Integer type, String practitionerId) {
        PractitionerInfoForAchievement practitionerInfo = new PractitionerInfoForAchievement(0D,0D,0);
        List<AclCustomerFortuneStatistics> rankList = new ArrayList<>();
        if(!rankInfoList.isEmpty()){
            //排序---1-保费，2-佣金，3-件数
            if(2 == type){
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyc).reversed());
            }else if(3 == type){
                rankInfoList.sort(Comparator.comparingInt(PractitionerRankInfo::getCount).reversed());
            }else{
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyp).reversed());
            }
            AclCustomerFortuneStatistics fortuneStatistics;
            int rank = 1;
            Long practitionerIdForOnLine;
            String practitionerIdItem;
            for(PractitionerRankInfo practitionerItem : rankInfoList){
                //更新对象里面的内容，将PractitionerIdForOnLine里的信息赋值到PractitionerId
                practitionerIdForOnLine = practitionerItem.getPractitionerIdForOnLine();
                if(practitionerIdForOnLine != null){
                    practitionerItem.setPractitionerId(practitionerIdForOnLine.toString());
                }
                practitionerIdItem = practitionerItem.getPractitionerId();
                if(rank <= 10){//排名
                    fortuneStatistics = new AclCustomerFortuneStatistics();
                    BeanUtils.copyProperties(practitionerItem,fortuneStatistics);
                    fortuneStatistics.setSubordinateSystemName(practitionerItem.getSpcDivName());
                    fortuneStatistics.setRank(rank);
                    rankList.add(fortuneStatistics);
                }
                if(practitionerId.equals(practitionerIdItem)){//赋值
                    BeanUtils.copyProperties(practitionerItem,practitionerInfo);
                    practitionerInfo.setRank(rank);
                    if(rank > 10){
                        break;
                    }
                }
                rank ++;
            }
        }
        responseVO.setPractitionerInfo(practitionerInfo);
        responseVO.setRank(rankList);
    }

    @Override
    public SettingQueryResponseVO settingQuery(SettingQueryRequestVO requestVO) {
        SettingQueryResponseVO responseVO = new SettingQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();//入参经纪人id
        //需要查询的信息 1.自我介绍 2.我的设置 3.头像 4.个人微信二位码 5.生活照
        //1.2均在ag_acl_practitioner表中查询
        AclPractitionerInfo practitioner = practitionerDALService.findPractitionerById(practitionerId);
        String bioIntro = practitioner.getBioIntro();//经纪人个人介绍
        Integer isMobileShow = practitioner.getIsMobileShow();
        Integer isNameShow = practitioner.getIsNameShow();
        //3.4.5在ag_acl_file_upload中查询
        //target_type 1=从业人员practioner表, 2=员工user表,  3=客户customer表, 4=渠道客户channel表
        //target_use_for 文件用途 1=头像 2=生活照 3=证照 4=毕业证书 5=营业登记证 6.咨询定制方案 7.客户身份证正面照片 8.客户身份证反面照片 9.个人微信二维码
        //查询ag_acl_file_upload中isActive=1&&target_type=1&&target_id=practitionerId的信息
        AclFileUpload fileUpload = new AclFileUpload();
        fileUpload.setIsActive(1);
        fileUpload.setTargetType(1);
        fileUpload.setTargetId(practitionerId);
        List<AclFileUpload> fileUploads = aclFileUploadDALService.findByAclFileUpload(fileUpload);
        //筛选出头像
        BeanPropertyValueEqualsPredicate predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",1);
        List<AclFileUpload> headImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        //头像至多一张
        String headImgUrl = null;
        if (!headImgs.isEmpty()){
            headImgUrl = headImgs.get(0).getFilePath();
        }
        //筛选出生活照
        predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",2);
        List<AclFileUpload> lifeImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        List<LifeImg> lifeImgUrls = new ArrayList<>();
        for (AclFileUpload lifeImg: lifeImgs){
            LifeImg info = new LifeImg();
            info.setId(lifeImg.getId());
            info.setLifeImgUrl(lifeImg.getFilePath());
            lifeImgUrls.add(info);
        }
        //筛选出二维码
        predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",9);
        List<AclFileUpload> wxQRImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        String wxQRImgUrl = null;
        if (!wxQRImgs.isEmpty()){
            wxQRImgUrl = wxQRImgs.get(0).getFilePath();
        }
        //返回参数
        responseVO.setPractitionerId(practitionerId);
        responseVO.setBioIntro(bioIntro);
        responseVO.setIsMobileShow(isMobileShow);
        responseVO.setIsNameShow(isNameShow);
        responseVO.setHeadImgUrl(headImgUrl);
        responseVO.setLifeImgUrls(lifeImgUrls);
        responseVO.setWxQRImgUrl(wxQRImgUrl);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public ImgDeleteResponseVO imgDelete(ImgDeleteRequestVO requestVO) {
        ImgDeleteResponseVO responseVO = new ImgDeleteResponseVO();
        Long fileId = requestVO.getFileId();
        AclFileUpload fileUpload = new AclFileUpload();
        fileUpload.setId(fileId);
        fileUpload.setIsActive(0);
        aclFileUploadDALService.updateFileUpload(fileUpload);
        responseVO.setPractitionerId(requestVO.getPractitionerId());
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    @Transactional
    public SettingSaveResponseVO settingSave(SettingSaveRequestVO requestVO) throws Exception {
        SettingSaveResponseVO responseVO = new SettingSaveResponseVO();
        //入参判断
        CommonResult commonResult = paramCheck(requestVO);
        if (!commonResult.isSuccess()){
            responseVO.setCommonResult(commonResult);
            return responseVO;
        }
        //保存经纪人自我介绍及设置
        practitionerMySettingSave(requestVO);
        String settingSave = requestVO.getSettingSave();
        if (settingSave.equalsIgnoreCase("img")){
            String message;
            //保存头像
            message = practitionerHeadImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }
            //保存生活照
            message = practitionerLifeImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }
            //保存二维码
            message = practitionerWXQRImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }

        }
        responseVO.setCommonResult(commonResult);
        return responseVO;
    }

    @Override
    public MediaGetRespVO mediaGet(MediaGetReqVO requestVO) {
        MediaGetRespVO mediaGetRespVO=new MediaGetRespVO();
        boolean success=true;
        String message=ZHBErrorConfig.getErrorInfo("800000");
        String mediaId = requestVO.getMediaId();
        String accessToken = wechatService.obtainToken(new TokenRequest());
        System.out.println("accessToken:"+accessToken);
        TicketRequest ticketRequest = new TicketRequest();
        ticketRequest.setAccessToken(accessToken);
        String jsapiTicket = wechatService.obtainTicket(ticketRequest);
        System.out.println("jsapiTicket:"+jsapiTicket);
        String ImgUrl= "https://api.weixin.qq.com/cgi-bin/media/get?access_token="+accessToken+"&media_id="+mediaId;
        String scale = requestVO.getScale();
        //判断上传尺寸是否符合要求
        if(!CommonUtil.isNullOrBlank(scale)){
            Map<String,Object> input = HttpUtil.getInput(ImgUrl);
            if (!(boolean)input.get("success")){
                mediaGetRespVO.setCommonResult(new CommonResult(false, (String)input.get("message")));
                return mediaGetRespVO;
            }
            InputStream inputStream = (InputStream) input.get("is");
            //判断图像尺寸
            Image img = null;
            try {
                img = ImageIO.read(inputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
                mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830014")));
                return mediaGetRespVO;
            }else {
                double width = img.getWidth(null);
                double height = img.getHeight(null);
                double value =height/width;
                Double scaleDouble = Double.valueOf(scale);
                if (value !=scaleDouble) {
                    if (scaleDouble == 1){
                        //上传头像尺寸比例为1:1
                        mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830016")));
                        return mediaGetRespVO;
                    }else if(scaleDouble ==0.75) {
                        mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830015")));
                        return mediaGetRespVO;
                    }
                }
            }
        }
//		System.out.println("ImgUrl:"+ImgUrl);
        mediaGetRespVO.setImgUrl(ImgUrl);
        mediaGetRespVO.setCommonResult(new CommonResult(success, message));
        return mediaGetRespVO;
    }

    private CommonResult paramCheck(SettingSaveRequestVO requestVO) {
        //检查入参判断
        Long practitionerId = requestVO.getPractitionerId();
        if (CommonUtil.isNullOrZero(practitionerId)){
            String[] params = {"practitionerId"};
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001",params));
        }
        //生活照至多三张
        List<String> lifeImgUrls = requestVO.getLifeImgUrls();
        if (lifeImgUrls != null){
            if (!lifeImgUrls.isEmpty()){
                AclFileUpload aclFileUpload = new AclFileUpload();
                aclFileUpload.setTargetType(1);
                aclFileUpload.setTargetId(practitionerId);
                aclFileUpload.setTargetUseFor(2);
                aclFileUpload.setIsActive(1);
                List<AclFileUpload> fileUploads = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
                if (!fileUploads.isEmpty()){
                    int size = lifeImgUrls.size()+fileUploads.size();
                    if (size>=4){
                        return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830019"));
                    }
                }
            }
        }
        return new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000"));
    }

    private void practitionerMySettingSave(SettingSaveRequestVO requestVO) {
        //修改个人设置，个人介绍
        String settingSave = requestVO.getSettingSave();
        if (settingSave.equalsIgnoreCase("isShow")||settingSave.equalsIgnoreCase("intro")){
            Long practitionerId = requestVO.getPractitionerId();
            AclPractitionerInfo practitioner = practitionerDALService.findPractitionerById(practitionerId);
            if (settingSave.equalsIgnoreCase("intro")){
                practitioner.setBioIntro(requestVO.getBioIntro());
            }else if (settingSave.equalsIgnoreCase("isShow")){
                practitioner.setIsNameShow(requestVO.getIsNameShow());
                practitioner.setIsMobileShow(requestVO.getIsMobileShow());
            }
            practitionerDALService.updatePractitioner(practitioner);
        }
    }

    private String practitionerHeadImgSave(SettingSaveRequestVO requestVO) throws Exception {
        String headImgUrl = requestVO.getHeadImgUrl();
        if (CommonUtil.isNullOrBlank(headImgUrl)){
            //如果头像没有地址，则认为没有上传
            return null;
        }
        //上传图片
        return uploadImage(headImgUrl,requestVO.getPractitionerId(),1);
    }

    private String practitionerLifeImgSave(SettingSaveRequestVO requestVO) throws Exception {
        List<String> lifeImgUrls = requestVO.getLifeImgUrls();
        StringBuilder message = new StringBuilder(" ");
        int i = 1;
        for (String lifeImgUrl: lifeImgUrls){
            String resp = uploadImage(lifeImgUrl, requestVO.getPractitionerId(), 2);
            if (!CommonUtil.isNullOrBlank(resp)){
                message.append(i).append(",");
            }
            i++;
        }
        if (!CommonUtil.isNullOrBlank(message.toString())){
            return "此次上传第"+message+"张图片尺寸不符合要求!!";
        }
        return null;
    }

    private String practitionerWXQRImgSave(SettingSaveRequestVO requestVO) throws Exception{
        String wxQRImgUrl = requestVO.getWxQRImgUrl();
        if (CommonUtil.isNullOrBlank(wxQRImgUrl)){
            //如果头像没有地址，则认为没有上传
            return null;
        }
        //上传图片
        return uploadImage(wxQRImgUrl,requestVO.getPractitionerId(),9);
    }

    private String uploadImage(String headImgUrl, Long practitionerId,Integer targetUseFor) throws Exception{
        Map<String, Object> input = HttpUtil.getInput(headImgUrl);
        if (!(boolean)input.get("success")){
            if (targetUseFor==1){
                //地址转流失败
                return ZHBErrorConfig.getErrorInfo("830056");
            }else if(targetUseFor==2){
                return ZHBErrorConfig.getErrorInfo("830057");
            }else if(targetUseFor==9){
                return ZHBErrorConfig.getErrorInfo("830058");
            }
        }
        //获取头像流
        InputStream inputStream = (InputStream) input.get("is");
        //判断图像尺寸
        BufferedImage img = ImageIO.read(inputStream);
        if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            return ZHBErrorConfig.getErrorInfo("830014");
        }else {
            double width = img.getWidth(null);
            double height = img.getHeight(null);
            double value =height/width;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write(img, "jpg", os);
            inputStream = new ByteArrayInputStream(os.toByteArray());
            if (value !=1&&(targetUseFor == 1 || targetUseFor == 9)){
                //上传头像尺寸比例为1:1
                return ZHBErrorConfig.getErrorInfo("830016");
            }else if(value !=0.75 && targetUseFor == 2){
                return ZHBErrorConfig.getErrorInfo("830015");
            }
        }
        //上传图片至阿里云
        String prefix = "broker/"+practitionerId+"/";
        String originalFilename = generateKey(targetUseFor);
        String key = prefix + originalFilename;
        String putFileToOss = ossService.putFileToOss(null,key,inputStream);
        //将之前头像设置为不启用
        if (targetUseFor==1||targetUseFor==9){
            updateImgOld(practitionerId,targetUseFor);
        }
        //保存到数据库
        AclPractitionerInfo practitioner = practitionerDALService.findPractitionerById(practitionerId);
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetType(1);
        aclFileUpload.setTargetId(practitioner.getId());
        String practitionerCode = practitioner.getPractitionerCode();
        aclFileUpload.setTargetNo(practitionerCode);
        aclFileUpload.setFileType("jpg");
        aclFileUpload.setFileName(originalFilename);
        aclFileUpload.setFilePath(putFileToOss);
        aclFileUpload.setTargetUseFor(targetUseFor);
        aclFileUpload.setFileSize(String.valueOf(inputStream.available()));
        aclFileUpload.setOssKey(key);
        aclFileUpload.setIsActive(1);
        aclFileUpload.setUploadedAt(new Date());
        aclFileUpload.setUploadedBy(-1L);
        aclFileUpload.setTargetSeq(getTargetSeq(practitioner.getId(),targetUseFor));
        aclFileUploadDALService.saveFileUpload(aclFileUpload);
        return null;
    }
    private String generateKey(int targetUseFor) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return targetUseFor+sdf.format(new Date()) + CommonUtil.getRandomNum(3)+".jpg";
    }

    private void updateImgOld(Long practitionerId, int targetUseFor) {
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetId(practitionerId);
        aclFileUpload.setTargetType(1);
        aclFileUpload.setIsActive(1);
        aclFileUpload.setTargetUseFor(targetUseFor);
        List<AclFileUpload> uploads = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
        if (!uploads.isEmpty()){
            for (AclFileUpload fileUpload :uploads){
                fileUpload.setIsActive(0);
                aclFileUploadDALService.updateFileUpload(fileUpload);
            }
        }
    }

    private Integer getTargetSeq(Long practitionerId, Integer targetUseFor) {
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetType(1);
        aclFileUpload.setTargetId(practitionerId);
        aclFileUpload.setTargetUseFor(targetUseFor);
        List<AclFileUpload> aclFileUploadList = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
        return aclFileUploadList.size()+1;
    }
}
