package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerHiringApproveRecords;
import com.yd.dal.mapper.customer.AclPractitionerHiringApproveRecordsMapper;
import com.yd.dal.service.customer.AclPractitionerHiringApproveRecordsDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("aclPractitionerHiringApproveRecordsDALService")
public class AclPractitionerHiringApproveRecordsDALServiceImpl implements AclPractitionerHiringApproveRecordsDALService {
    @Resource
    private AclPractitionerHiringApproveRecordsMapper mapper;
    @Override
    public void save(List<AclPractitionerHiringApproveRecords> hiringApproveRecordsList) {
        mapper.batchInsert(hiringApproveRecordsList);
    }

    @Override
    public void save(AclPractitionerHiringApproveRecords hiringApproveRecords) {
        mapper.insert(hiringApproveRecords);
    }

    @Override
    public List<AclPractitionerHiringApproveRecords> queryListByBasicInfoId(Long hiringBasicInfoId) {
        return mapper.queryListByBasicInfoId(hiringBasicInfoId);
    }

    @Override
    public int deleteByHiringBasicInfoId(Long hiringBasicInfoId) {
        return mapper.deleteByHiringBasicInfoId(hiringBasicInfoId);
    }
}
