package com.yd.dal.entity.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * ag_po_order
 * @author 
 */
@Data
public class PoOrder implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 规则层级 1-insurer 2-product 3-plan
     */
    private Integer configLevel;

    /**
     * 产品ID, FK ag_product.id
     */
    private Long productId;

    /**
     * 方案ID
     */
    private Long planId;

    /**
     * order#
     */
    private String orderNo;

    /**
     * order datetime 0000-00-00 00:00:00
     */
    private Date orderDate;

    /**
     * order price
     */
    private BigDecimal orderPrice;

    /**
     * 报价单ag_po_quotation.id
     */
    private Long quotationId;

    /**
     * 报价单ag_po_quotation.quote_no
     */
    private Long quoteNo;

    /**
     * ag_product_category.id,id = 3车险
     */
    private Long productCategoryId;

    /**
     * 目的地
     */
    private String destination;

    /**
     * FK ag_md_continent.id
     */
    private Long destinationContinentId;

    /**
     * FK ag_md_region.id
     */
    private Long destinationRegionId;

    /**
     * FK ag_md_country.id
     */
    private Long destinationCountryId;

    /**
     * 起保日期
     */
    private Date effectiveStartDate;

    /**
     * 终保日期
     */
    private Date effectiveEndDate;

    /**
     * 1-365 days
     */
    private Integer coverLength;

    private Integer coverAdultQty;

    private Integer coverUnderageQty;

    /**
     * 1.Wechat 2.AliPay 3.Bank
     */
    private Long paymentMethodId;

    /**
     * pay url
     */
    private String payUrl;

    /**
     * 统一支付落地页1：H5，2：group
     */
    private Integer payFrom;

    private String insurerPdfUrl;

    /**
     * 0=No, 1=Yes
     */
    private Integer isMsgSent;

    /**
     * 0=无车船税, 1=有车船税
     */
    private Integer isCarTax;

    /**
     * 银盾企业增值税缺省为0，小数
     */
    private BigDecimal ydValueAddedTax;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission银盾来佣佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 银盾来佣佣金
     */
    private BigDecimal commissionAmount;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission公告佣金率
     */
    private BigDecimal announcementCommissionRate;

    /**
     * 公告佣金
     */
    private BigDecimal announcementCommissionAmount;

    /**
     * FK ag_acl_channel_referral_rate个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * 最终个人佣金率 = 银盾来佣率 * (1 + yd_value_added_tax) * 银盾公告佣金率 * 个人职级佣金率
     */
    private BigDecimal referralRate;

    /**
     * 最终个人佣金 = order_price / (1 + yd_value_added_tax) * 银盾来佣率 * 银盾公告佣金率 * 个人职级佣金率
     */
    private BigDecimal referralAmount;

    /**
     * FK ag_order_policy.id
     */
    private Long policyId;

    private String policyNo;

    /**
     * 市场活动
     */
    private String mktCampaign;

    /**
     * 市场活动任务
     */
    private String mktTask;

    /**
     * 0=No, 1=Yes
     */
    private Integer isConverted;

    /**
     * 1=open 2=confirm 3=completed 4=cancelled 5=overdue 9=error
     */
    private Integer status;

    /**
     * 1=pending 2=paid 3=received 9=error
     */
    private Integer paymentStatus;

    /**
     * flag
     */
    private String flag;

    private Long customerId;

    /**
     * 分享人customer_id
     */
    private Long referralCustomerId;

    /**
     * 分享码
     */
    private String shareCode;

    private Long insurerId;

    /**
     * 数据来源
     */
    private String dataSource;

    /**
     * 有无社保（1-有；0-无）
     */
    private Integer isSocialInsured;

    /**
     * 保障计划 1=终身 2=保障至70岁 3=保障至80岁
     */
    private Integer coverTerm;

    /**
     * 缴费期限
     */
    private Integer paymentTerm;

    /**
     * Y=年, M=月, D=日, A=岁
     */
    private String paymentTermUnit;

    /**
     * 缴费间隔; -1-不定期交、0-一次交清、1-月交、3-季交、6-半年交、12-年交
     */
    private Integer payInterval;

    /**
     * ERP系统是否可见 1-可见 2-不可见
     */
    private String viewFlag;

    /**
     * 动态字段A
     */
    private String dynamicFieldA;

    /**
     * 动态字段B
     */
    private String dynamicFieldB;

    private String dynamicFieldC;

    /**
     * 动态字段D
     */
    private String dynamicFieldD;

    /**
     * 驾乘险车牌号码
     */
    private String plateNo;

    /**
     * group团单添加订单说明
     */
    private String memo;

    /**
     * 试算参数报文
     */
    private String productTableRequestJson;

    /**
     * 核定座位数
     */
    private Integer verifiedSeats;

    /**
     * 驾乘险车架号
     */
    private String frameNo;

    /**
     * 保障标的物所在省份, FK ag_md_province.id
     */
    private Long subjectProvinceId;

    /**
     * 保障标的物所在城市, FK ag_md_city.id
     */
    private Long subjectCityId;

    /**
     * 保障标的物所在详细地址
     */
    private String subjectAddress;

    /**
     * 民宿房间数
     */
    private String roomQty;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * 修改人
     */
    private Long updatedBy;

    /**
     * 营销投放渠道来源 hmsr
     */
    private String sourceChannel;

    /**
     * 营销投放产品名 hmpl
     */
    private String sourcePlanName;

    /**
     * 营销投放推送日期 hmkw
     */
    private String sourcePublishdate;

    /**
     * 营销投放推送文章或其他 hmci
     */
    private String sourceArticle;

    /**
     * 访问IP
     */
    private String ipAddress;

    /**
     * 访问IP所属的地域
     */
    private String ipRegion;

    /**
     * 续保去年的order id
     */
    private Long renewOrderId;

    /**
     * 0=No, 1=Yes 是否已续保完成? 会针对去年订单做异动
     */
    private Integer isRenewComplete;

    /**
     * 是否银盾收保费 0=No, 1=Yes
     */
    private Integer isPayToYd;

    /**
     * 保险费过期未付选择 保险单借款垫缴:Y中止合同:N
     */
    private String autoPayFlag;

    private static final long serialVersionUID = 1L;
}