package com.yd.api.customer.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.github.pagehelper.PageInfo;
import com.yd.api.customer.vo.CustomerFortuneRequestVO;
import com.yd.api.customer.vo.CustomerFortuneResponseVO;
import com.yd.api.customer.vo.CustomerQueryRequestVO;
import com.yd.api.customer.vo.CustomerQueryResponseVO;
import com.yd.api.customer.vo.CustomerVO;
import com.yd.dal.entity.customer.Customer;
import com.yd.dal.entity.customer.CustomerFortune;
import com.yd.dal.mapper.customer.CustomerFortuneMapper;
import com.yd.dal.service.customer.CustomerDA;

@Service("customerServiceImpl")
public class CustomerServiceImpl implements CustomerService{

	@Autowired
    private CustomerDA customerServiceDA;

	@Autowired
    private CustomerFortuneMapper customerFortuneMapper;

	@Override
	public List<CustomerVO> listAllCustomer() {
		List<CustomerVO> listTo =new ArrayList<CustomerVO>();
		List<Customer> list = new ArrayList<Customer>();
		list = customerServiceDA.listAllCustomers();
		CustomerVO oneDestVO;
    	for(Customer oneSrc:list)
    	{
    		oneDestVO = new CustomerVO();
    		BeanUtils.copyProperties(oneSrc, oneDestVO);
    		listTo.add(oneDestVO);
    	}
		return listTo;
	}
	
	@Override
	public CustomerQueryResponseVO findByPage(CustomerQueryRequestVO customerQueryRequestVO)
	{
		CustomerQueryResponseVO customerQueryResponseVO = new CustomerQueryResponseVO();
		
		PageInfo<Customer> page = customerQueryRequestVO.getPage();

		PageInfo<Customer> list = customerServiceDA.findByPage(page.getPageNum(), page.getSize());
  	
    	customerQueryResponseVO.setCustomerId(customerQueryRequestVO.getCustomerId());
    	
    	customerQueryResponseVO.setCustomerPage(list);
    	
		return customerQueryResponseVO;
	}

	@Override
	public CustomerFortuneResponseVO selectByCustomerId(CustomerFortuneRequestVO request) {
		
		CustomerFortuneResponseVO customerQueryResponseVO = new CustomerFortuneResponseVO();
		Long customerId = request.getCustomerId();
		
		PageInfo<CustomerFortune> page = request.getPage();

		PageInfo<CustomerFortune> list = customerServiceDA.selectByCustomerId(customerId, page.getPageNum(), page.getSize());
  	
    	customerQueryResponseVO.setCustomerId(customerId);
    	
    	customerQueryResponseVO.setCustomerPage(list);
    	
		return customerQueryResponseVO;
	}	
}

