package com.yd.dal.service.agms;

import com.yd.dal.entity.agms.fortune.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xxy
 */
public interface AgmsFortuneDALService {
    /**
     * 通过customerid查询财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     * @param customerIds customerIds
     * @return 财富基本信息(历史累积财富  已退保财富  已提现财富 等)
     */
    Map<Long,CustomerFortuneStatisticalInfo> findFortuneStatisticalByCustomers(Set<Long> customerIds);

    /**
     * 发佣检核列表
     * @param requestVO 过滤条件
     * @return 返回结果
     */
    List<CommissionPayoutStatus> commissionPayoutStatusQuery(CommissionPayoutStatusQueryInfo requestVO);

    /**
     * 通过customerId和payId查询fortune记录
     * @param customerId customerId
     * @param payId payId
     * @return FortunePayToOrderInfo
     */
    List<FortunePayToOrderInfo> fortunePayToOrder(Long customerId, Long payId);

    /**
     * 支付列表插叙
     * @param info info
     * @return WithdrawLabelInfo
     */
    List<WithdrawLabelInfo> transformForWithdrawLabel(WithdrawQueryInfo info);
}
