package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import com.yd.api.agms.service.AgmsStatementService;
import com.yd.api.agms.vo.statement.FinancialStatementRequestVO;
import com.yd.api.agms.vo.statement.FinancialStatementResponseVO;
import com.yd.api.agms.vo.statement.statementData;
import com.yd.api.commission.service.CommissionService;
import com.yd.api.result.CommonResult;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("agmsStatementService")
public class AgmsStatementServiceImpl implements AgmsStatementService {
    @Autowired
    private CommissionService commissionService;
    @Override
    public FinancialStatementResponseVO financialPredictStatement(FinancialStatementRequestVO requestVO, HttpServletResponse response) {
        FinancialStatementResponseVO responseVO = new FinancialStatementResponseVO();
        PageInfo<statementData> pageInfo = requestVO.getPageInfo();
        String inCommissionDateSpan = requestVO.getInCommissionDateSpan();//来佣开始时间
        String outCommissionDateSpan = requestVO.getOutCommissionDateSpan();//发佣开始时间
        String inCommissionStartTime = null;//来佣开始时间
        String inCommissionEndTime = null;//发佣开始时间
        String outCommissionStartTime= null;//来佣开始时间
        String outCommissionEndTime= null;//发佣开始时间
        if(!Strings.isNullOrEmpty(inCommissionDateSpan)){
            String[] inDataSpan = inCommissionDateSpan.split(":");
            if(inDataSpan.length == 1){
                inCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
            }else if(inDataSpan.length == 2){
                inCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
                inCommissionEndTime = getTime(inDataSpan[1]);
//                inCommissionEndTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inDataSpan[1],"yyyy-MM-dd"),"yyyyMM");
            }
        }
        if(!Strings.isNullOrEmpty(outCommissionDateSpan)){
            String[] outDataSpan = outCommissionDateSpan.split(":");
            if(outDataSpan.length == 1){
                outCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
            }else if(outDataSpan.length == 2){
                outCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
                outCommissionEndTime = getTime(outDataSpan[1]);
//                outCommissionEndTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outDataSpan[1],"yyyy-MM-dd"),"yyyyMM");
            }
        }
        String insurerBranchId = requestVO.getInsurerBranchId();//分公司
        String deptId = requestVO.getDeptId();//营业部
        String subordinateId = requestVO.getSubordinateId();//体系
        Integer type = requestVO.getType();
        Integer isStatement = requestVO.getIsStatement();
        if(isStatement == 1){
            List<statementData> dataList = commissionService.getStatementData(isStatement,type, inCommissionStartTime, outCommissionStartTime,inCommissionEndTime,outCommissionEndTime,insurerBranchId,deptId,subordinateId);
            createCSV(type,dataList,response);
        }else{
            PageInfo<statementData> dataPage = commissionService.getStatementDataByPage(pageInfo.getPageNum(),pageInfo.getSize(),isStatement,type, inCommissionStartTime, outCommissionStartTime,inCommissionEndTime,outCommissionEndTime,insurerBranchId,deptId,subordinateId);
            responseVO.setPredictStatementDataList(dataPage);
        }
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    private String getTime(String time) {
        Date date = CommonUtil.stringParseDate(time,"yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH,-1);
        date = calendar.getTime();
        return CommonUtil.dateParseString(date,"yyyyMM");
    }

    private void createCSV(Integer type, List<statementData> dataList, HttpServletResponse response) {
        String CSV_COLUMN_SEPARATOR = ",";//CSV文件列分隔符
        String CSV_ROW_SEPARATOR = "\r\n";//CSV文件行分隔符
        String charset = "UTF-8"; // 读取字符编码
        String[] columnName ;
        String tableName ;
        if(type == 2){
            tableName = "YD_FinancialStatement_predict_";
            columnName = new String[]{"序号","预估来佣年月","预估发佣年月","保单号","分公司","营业部","体系","经纪人姓名","员工编号","职阶","职阶率","保费","FYC","RYC","应收佣金","应发佣金","佣奖类型"};
        }else{
            tableName = "YD_FinancialStatement_actual_";
            columnName = new String[]{"序号","实际来佣年月","实际发佣年月","保单号","分公司","营业部","体系","经纪人姓名","员工编号","职阶","职阶率","保费","FYC","RYC","应收佣金","应发佣金","佣奖类型"};
        }
        // 保证线程安全
        StringBuilder buf = new StringBuilder();
        // 组装表头
        for (String title : columnName) {
            buf.append(title).append(CSV_COLUMN_SEPARATOR);
        }
        buf.append(CSV_ROW_SEPARATOR);
        // 组装数据
        if (CollectionUtils.isNotEmpty(dataList)) {
            for (int i = 0; i < dataList.size(); i++) {
                statementData statementData = dataList.get(i);//遍历每个对象
                buf.append(i + 1).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getInCommissionTime()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getOutCommissionTime()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPolicyNo()+"\t").append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getInsurerBranch()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getDept()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getSubordinate()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPractitioner()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPractitionerIdEG()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getTitle()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getTitleRate()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPremium()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getFYC()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getRYC()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getRightReceiveCommission()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getRightPayCommission()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getCommissionType()).append(CSV_COLUMN_SEPARATOR);
                buf.append(CSV_ROW_SEPARATOR);
            }
        }
        // 设置文件后缀
        String fn = tableName + System.currentTimeMillis()  + ".csv";
        String headStr = "attachment; filename=\"" + fn + "\"";
        // 设置响应
        response.setContentType("APPLICATION/ms-csv.numberformat");
        response.setCharacterEncoding(charset);
        response.setHeader("Content-Disposition", headStr);
        response.setHeader("Cache-Control", "max-age=30");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Pragma", "public");
        OutputStream os = null;
        try {
            os = response.getOutputStream();
            os.write(buf.toString().getBytes("GBK"));
            os.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            if(os != null){
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }

}
