package com.yd.dal.service.marketing.Impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.yd.api.practitioner.vo.opportunity.SalesScoreDetail;
import com.yd.dal.entity.marketing.MktLeadsAssignedTrack;
import com.yd.dal.mapper.marketing.MktLeadsAssignedTrackMapper;
import com.yd.dal.service.marketing.MktLeadsAssignedTrackDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

@Service("mktLeadsAssignedTrackDALService")
public class MktLeadsAssignedTrackDALServiceImpl implements MktLeadsAssignedTrackDALService {
    @Resource
    private MktLeadsAssignedTrackMapper mktLeadsAssignedTrackMapper;

    @Override
    public List<MktLeadsAssignedTrack> findByMktLeadsAssignedTrack(MktLeadsAssignedTrack mktLeadsAssignedTrack) {
        Page<MktLeadsAssignedTrack> destList =  mktLeadsAssignedTrackMapper.selectByPrimaryKeySelective(mktLeadsAssignedTrack);
        PageInfo<MktLeadsAssignedTrack> pageInfo = new PageInfo<>(destList);
        List<MktLeadsAssignedTrack> list = pageInfo.getList();
        return list;
    }

    @Override
    public void saveTrack(MktLeadsAssignedTrack track) {
        mktLeadsAssignedTrackMapper.insertSelective(track);
    }

    @Override
    public void updateTrack(MktLeadsAssignedTrack track) {
        mktLeadsAssignedTrackMapper.updateByPrimaryKeySelective(track);
    }

    @Override
    public List<MktLeadsAssignedTrack> findByTrackTimeForNew(MktLeadsAssignedTrack mktLeadsAssignedTrack) {
        return mktLeadsAssignedTrackMapper.findByTrackTimeForNew(mktLeadsAssignedTrack);
    }

    @Override
    public HashMap<String, BigDecimal> totalStatisticsForTeam(List<Long> practitionerIds) {
        return mktLeadsAssignedTrackMapper.totalStatisticsForTeam(practitionerIds);
    }

    @Override
    public MktLeadsAssignedTrack findByListNotesForCustomerId(Long customerId) {
        return mktLeadsAssignedTrackMapper.findByListNotesForCustomerId(customerId);
    }

    @Override
    public List<SalesScoreDetail> getSalesScoreDetailByPractitionerId(Long practitionerId, String time) {
        return mktLeadsAssignedTrackMapper.getSalesScoreDetailByPractitionerId(practitionerId, time);
    }

    @Override
    public void deleteScheduleTrackById(Long scheduleTrackId) {
        mktLeadsAssignedTrackMapper.deleteScheduleTrackById(scheduleTrackId);
    }

    @Override
    public int updateInformedOssPathByInformedId(String ossPath, Long informedId) {
        return mktLeadsAssignedTrackMapper.updateInformedOssPathByInformedId(ossPath, informedId);
    }

    @Override
    public int updateCustomerIdByLeadsAssignedId(Long customerId, Long leadsAssignedId) {
        return mktLeadsAssignedTrackMapper.updateCustomerIdByLeadsAssignedId(customerId, leadsAssignedId);
    }
}
