package com.yd.dal.service.customer.impl;

import com.yd.api.practitioner.vo.recruit.PractitionerPotentialInfo;
import com.yd.dal.entity.customer.AclPractitionerPotential;
import com.yd.dal.mapper.customer.AclPractitionerPotentialMapper;
import com.yd.dal.service.customer.AclPractitionerPotentialDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("aclPractitionerPotentialDALService")
public class AclPractitionerPotentialDALServiceImpl implements AclPractitionerPotentialDALService {

    @Autowired
    private AclPractitionerPotentialMapper aclPractitionerPotentialMapper;
    @Override
    public List<AclPractitionerPotential> findByMobileNo(String mobileNo, Integer isActive) {
        return aclPractitionerPotentialMapper.findByMobileNo(mobileNo,isActive);
    }

    @Override
    public int update(AclPractitionerPotential practitionerPotential) {
        return aclPractitionerPotentialMapper.updateByPrimaryKeySelective(practitionerPotential);
    }

    @Override
    public List<PractitionerPotentialInfo> findByPractitionerIdAndLasted(Long practitionerId) {
        List<PractitionerPotentialInfo> temp = aclPractitionerPotentialMapper.findByPractitionerIdAndLasted(practitionerId);
        Map<Long,PractitionerPotentialInfo> potentialInfoMap = new HashMap<>();
        Long potentialId;
        Long trackId,trackMaxId;
        for(PractitionerPotentialInfo item :temp){
            potentialId = item.getPotentialId();
            trackId = item.getTrackId();
            if(potentialInfoMap.containsKey(potentialId)){
                trackMaxId = potentialInfoMap.get(potentialId).getTrackId();
                if(trackMaxId < trackId){
                    potentialInfoMap.put(potentialId,item);
                }
            }else{
                potentialInfoMap.put(potentialId,item);
            }
        }
        List<PractitionerPotentialInfo> result = new ArrayList<>(potentialInfoMap.values());
        result.sort((o1, o2) -> o2.getPotentialId().compareTo(o1.getPotentialId()));
        return result;
    }

    @Override
    public int save(AclPractitionerPotential practitionerPotential) {
        return aclPractitionerPotentialMapper.insert(practitionerPotential);
    }
}
