package com.yd.dal.service.customer.impl;

import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.dal.entity.customer.AclCustomerLog;
import com.yd.dal.mapper.customer.AclCustomerLogMapper;
import com.yd.dal.service.customer.AclCustomerLogDALService;
import com.yd.util.CommonUtil;
import com.yd.util.SpringContextUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("aclCustomerLogDALService")
public class AclCustomerLogDALServiceImpl implements AclCustomerLogDALService {

    @Resource
    private AclCustomerLogMapper aclCustomerLogMapper;

    /**
     * 根据customerId查询指定用户的日志
     * @param customerId
     * @return
     */
    public List<AclCustomerLog> findLogInfoByCustomerId(Long customerId) {
        List<AclCustomerLog> customerLogList = new ArrayList<>();
        if(customerId != null){
            customerLogList = aclCustomerLogMapper.findLogInfoByCustomerId(customerId);
        }
        return customerLogList;
    }

    /**
     * 保存用户日志
     * @param customerId 用户id
     * @param plateFlag 1-在线平台 2-经纪
     */
    public Long saveCustomerLog(Long customerId, int plateFlag, PractitionerLoginRequestVO requestVO) {
        AclCustomerLog customerLog = new AclCustomerLog();
        customerLog.setCustomerId(customerId);
        customerLog.setFromPlateform(plateFlag);
        customerLog.setFromSystemName(null != requestVO.getFromSystemName() ? requestVO.getFromSystemName().toUpperCase():"");
        customerLog.setMobileNo(requestVO.getMobileNo());
        customerLog.setLoginTime(new Date());
        if(null ==customerId){
            customerLog.setIsSuccess(2);
        }else{
            customerLog.setIsSuccess(1);
        }
        String ip = SpringContextUtil.getCurrentIpAddress();
        customerLog.setFromIp(ip);
        customerLog.setLoginName(requestVO.getName());
        customerLog.setMessage(requestVO.getMessage());
        customerLog.setCreatedAt(new Date());
        customerLog.setCreatedBy(-1L);
        aclCustomerLogMapper.insert(customerLog);
        return this.findLogInfoByMobileNo(requestVO.getMobileNo());
    }

    @Override
    public Long findLogInfoByMobileNo(String mobileNo) {
       return aclCustomerLogMapper.findLogInfoByMobileNo(mobileNo);
    }
}
