package com.yd.api.agms;

import com.alibaba.fastjson.JSON;
import com.yd.api.agms.service.*;
import com.yd.api.agms.vo.dashboard.*;
import com.yd.api.agms.vo.fortune.*;
import com.yd.api.agms.vo.hiring.*;
import com.yd.api.agms.vo.insurer.SealUploadResponseVO;
import com.yd.api.agms.vo.practitioner.PractitionerFileSharingListRequestVO;
import com.yd.api.agms.vo.practitioner.PractitionerFileSharingListResponseVO;
import com.yd.api.agms.vo.practitioner.PractitionerFileSharingSaveRequestVO;
import com.yd.api.agms.vo.practitioner.PractitionerFileSharingSaveResponseVO;
import com.yd.api.agms.vo.sharing.ControllerResponseVO;
import com.yd.api.agms.vo.statistics.FinancialStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.FinancialStatisticsResponseVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsResponseVO;
import com.yd.api.agms.vo.tag.TagUpdateRequestVO;
import com.yd.api.agms.vo.tag.TagUpdateResponseVO;
import com.yd.api.agms.vo.tag.TagViewUpdateRequestVO;
import com.yd.api.agms.vo.tag.TagViewUpdateResponseVO;
import com.yd.api.result.JsonResult;
import com.yd.util.CommonUtil;
import com.yd.util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

@Controller
@RestController
@RequestMapping("/agms")
public class AgmsController {
    @Autowired
    private AgmsDashboardService agmsDashboardService;
    @Autowired
    private AgmsStatisticsService agmsStatisticsService;
    @Autowired
    private AgmsFortuneService agmsFortuneService;
    @Autowired
    private AgmsHiringService agmsHiringService;
    @Autowired
    private AgmsSharingService agmsSharingService;
    @Autowired
    private AgmsPractitionerService agmsPractitionerService;
    @Autowired
    private AgmsInsurerService agmsInsurerService;
    @Autowired
    private AgmsTagService agmsTagService;

    /**
     * AGMS -- 财务管理报表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/financialPredictStatistics")
    public Object financialPredictStatistics(@RequestBody FinancialStatisticsRequestVO requestVO, HttpServletResponse response){
        JsonResult result = new JsonResult();
        FinancialStatisticsResponseVO responseVO = agmsStatisticsService.financialPredictStatistics(requestVO,response);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  PEP活动管理
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsPEP")
    public Object statisticsPEP(@RequestBody StatisticsPEPRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsPEPResponseVO responseVO = agmsDashboardService.statisticsPEP(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  商机预测
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsOpportunity")
    public Object statisticsOpportunity(@RequestBody StatisticsOpportunityRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsOpportunityResponseVO responseVO = agmsDashboardService.statisticsOpportunity(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  预测统计查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsForecastTotal")
    public Object statisticsForecastTotal(@RequestBody StatisticsForecastTotalRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsForecastTotalResponseVO responseVO = agmsDashboardService.statisticsForecastTotal(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  销售统计查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsSales")
    public Object statisticsSales(@RequestBody StatisticsSalesRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsSalesResponseVO responseVO = agmsDashboardService.statisticsSales(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  经纪人统计查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsPractitioner")
    public Object statisticsPractitioner(@RequestBody StatisticsPractitionerRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsPractitionerResponseVO responseVO = agmsDashboardService.statisticsPractitioner(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- 商机统计报表
     * @param requestVO requestVO
     * @return 响应数据
     */
    @RequestMapping(value="/leadsStatistics")
    public Object leadsStatistics(@RequestBody LeadsStatisticsRequestVO requestVO,HttpServletResponse response) {
        JsonResult result = new JsonResult();
        LeadsStatisticsResponseVO responseVO = agmsStatisticsService.leadsStatistics(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 修改佣金发放状态
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/commissionPayoutStatusUpdate")
    public Object commissionPayoutStatusUpdate(@RequestBody CommissionPayoutStatusUpdateRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommissionPayoutStatusUpdateResponseVO responseVO = agmsFortuneService.commissionPayoutStatusUpdate(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 修改佣金发放状态列表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/commissionPayoutStatusQuery")
    public Object commissionPayoutStatusQuery(@RequestBody CommissionPayoutStatusQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        CommissionPayoutStatusQueryResponseVO responseVO = agmsFortuneService.commissionPayoutStatusQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 支付列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/withdrawQuery")
    public Object withdrawQuery(@RequestBody WithdrawQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        WithdrawQueryResponseVO withdrawQueryResponseVO  = agmsFortuneService.withdrawQuery(requestVO);
        result.addResult(withdrawQueryResponseVO);
        result.setData(withdrawQueryResponseVO);
        return result;
    }

    /**
     * AGMS -- 提现财富对应订单查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/fortunePayToOrder")
    public Object fortunePayToOrder(@RequestBody FortunePayToOrderRequestVO requestVO) {
        JsonResult result = new JsonResult();
        FortunePayToOrderResponseVO responseVO = agmsFortuneService.fortunePayToOrder(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 财富批量支付
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/fortunePay")
    public Object fortunePay(@RequestBody FortunePayRequestVO requestVO) {
        JsonResult result = new JsonResult();
        FortunePayResponseVO responseVO = agmsFortuneService.fortunePay(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 发佣检核导出
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/exportCommissionPayoutStatusQuery")
    public Object exportCommissionPayoutStatusQuery(@RequestBody CommissionPayoutStatusQueryRequestVO requestVO, HttpServletResponse response) {
        JsonResult result = new JsonResult();
        ExportCommissionPayoutStatusQueryResponseVO responseVO = agmsFortuneService.exportCommissionPayoutStatusQuery(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 保单发佣清算明细报表导出
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/exportCommissionPayoutStatusQuerySheet2")
    public Object exportCommissionPayoutStatusQuerySheet2(@RequestBody CommissionPayoutStatusQueryRequestVO requestVO, HttpServletResponse response) {
        JsonResult result = new JsonResult();
        ExportCommissionPayoutStatusQueryResponseVO responseVO = agmsFortuneService.exportCommissionPayoutStatusQuerySheet2(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 导出财富文档
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/exportFortunePay")
    public Object exportFortunePay(@RequestBody ExportFortunePayRequestVO requestVO, HttpServletResponse response) {
        JsonResult result = new JsonResult();
        ExportFortunePayResponseVO responseVO = agmsFortuneService.exportFortunePay(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 查询预计发佣日期
     * @return 响应数据
     */
    @RequestMapping(value="/fortunePayoutBatchQuery",method = RequestMethod.GET)
    public Object fortunePayoutBatchQuery() {
        JsonResult result = new JsonResult();
        FortunePayoutBatchQueryResponseVO responseVO = agmsFortuneService.fortunePayoutBatchQuery();
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批详情查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerHiringDetail")
    public Object practitionerHiringDetail(@RequestBody PractitionerHiringDetailRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerHiringDetailResponseVO responseVO = agmsHiringService.practitionerHiringDetail(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerHiringListOld")
    public Object practitionerHiringListOld(@RequestBody PractitionerHiringListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerHiringListResponseVO responseVO = agmsHiringService.practitionerHiringList(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/practitionerHiringApprove")
    public Object practitionerHiringApprove(@RequestBody PractitionerHiringApproveRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerHiringApproveResponseVO responseVO = agmsHiringService.practitionerHiringApprove(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批列表查询第二版
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerHiringList")
    public Object practitionerHiringList(@RequestBody PractitionerHiringListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerHiringListResponseVO responseVO = agmsHiringService.practitionerHiringListV2(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 上传公司印章接口
     * @param sealFile
     * @param loginId
     * @param insurerBranchId
     * @param insurerBranchDeptId
     * @return
     */
    @RequestMapping(value="/sealUpload")
    public Object sealUpload(@RequestParam(value = "sealFile") MultipartFile sealFile,
                             @RequestParam(value = "loginId",required = true) Long loginId,
                             @RequestParam(value = "insurerBranchId",required = false) Long insurerBranchId,
                             @RequestParam(value = "insurerBranchDeptId",required = false) Long insurerBranchDeptId) {
        JsonResult result = new JsonResult();
        SealUploadResponseVO responseVO = agmsInsurerService.sealUpload(sealFile,loginId,insurerBranchId,insurerBranchDeptId);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    @RequestMapping(value="/controller")
    public Object controller(@RequestParam String action, @RequestParam(required = false) String callback, @RequestParam(value = "upfile",required = false) MultipartFile upfile) {
        ControllerResponseVO responseVO = agmsSharingService.controller(action, upfile);
        if (!CommonUtil.isNullOrBlank(callback)) {
            return callback +"(" + JSON.toJSONString(responseVO) + ")";
        }
        return responseVO;
    }
    /**
     * AGMS -- 经纪人保存文章
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerFileSharingSave")
    public Object practitionerFileSharingSave(@RequestBody PractitionerFileSharingSaveRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerFileSharingSaveResponseVO responseVO = agmsPractitionerService.practitionerFileSharingSave(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人查询文章
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerFileSharingList")
    public Object practitionerFileSharingList(@RequestBody PractitionerFileSharingListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerFileSharingListResponseVO responseVO = agmsPractitionerService.practitionerFileSharingList(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 标签修改
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/tagUpdate")
    public Object tagUpdate(@RequestBody TagUpdateRequestVO requestVO) {
        JsonResult result = new JsonResult();
        TagUpdateResponseVO responseVO = agmsTagService.tagUpdate(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 前端显示标签 保存与修改
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/tagViewUpdate")
    public Object tagViewUpdate(@RequestBody TagViewUpdateRequestVO requestVO) throws Exception{
        JsonResult result = new JsonResult();
        TagViewUpdateResponseVO responseVO = agmsTagService.tagViewUpdate(requestVO,null);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    
    /**
     * AGMS -- 前端显示标签 保存与修改,支持图片上次
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/tagViewFileUpdate")
    public Object tagViewFileUpdate(@RequestParam(value = "requestVO",required = true) String requestVO,
    		@RequestParam(value = "tagViewImage",required = false) MultipartFile tagViewImage) throws Exception{
		requestVO = new String(requestVO.getBytes("ISO-8859-1"),"UTF-8");
   		TagViewUpdateRequestVO request = (TagViewUpdateRequestVO)JsonUtil.jsonToObj(requestVO, TagViewUpdateRequestVO.class);
   		JsonResult result = new JsonResult();
        TagViewUpdateResponseVO responseVO = agmsTagService.tagViewUpdate(request,tagViewImage);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    
}
