package com.yd.rmi.tencent.wechatinterf.pojo.unifiedorder;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="xml")
@XmlType(propOrder = { "appid","mch_id","device_info","nonce_str","sign","sign_type","body","detail","attach","out_trade_no","fee_type","total_fee","spbill_create_ip","time_start","time_expire","goods_tag","notify_url","trade_type","product_id","limit_pay","openid","scene_info"})
public class UnifiedorderRequest {

	private String appid;	//公众账号ID
	private String mch_id;	//商户号
	private String device_info;	//设备号
	private String nonce_str;	//随机字符串
	private String sign;	//签名
	private String sign_type;	//签名类型
	private String body;	//商品描述
	private String detail;	//商品详情
	private String attach;	//附加数据
	private String out_trade_no;	//商户订单号
	private String fee_type;	//标价币种
	private int total_fee;	//标价金额
	private String spbill_create_ip;	//终端IP
	private String time_start;	//交易起始时间
	private String time_expire;	//交易结束时间
	private String goods_tag;	//订单优惠标记
	private String notify_url;	//通知地址
	private String trade_type;	//交易类型
	private String product_id;	//商品ID
	private String limit_pay;	//指定支付方式
	private String openid;	//用户标识
	private String scene_info;	//场景信息


	/**
	 * @param appid	公众账号ID
	 */
	public void setAppid(String appid) {
		this.appid = appid;
	}

	/**
	 * @return	appid	公众账号ID
	 */
	@XmlElement(name = "appid")
	public String getAppid() {
		return appid;
	}

	/**
	 * @param mch_id	商户号
	 */
	public void setMch_id(String mch_id) {
		this.mch_id = mch_id;
	}

	/**
	 * @return	mch_id	商户号
	 */
	@XmlElement(name = "mch_id")
	public String getMch_id() {
		return mch_id;
	}

	/**
	 * @param device_info	设备号
	 */
	public void setDevice_info(String device_info) {
		this.device_info = device_info;
	}

	/**
	 * @return	device_info	设备号
	 */
	@XmlElement(name = "device_info")
	public String getDevice_info() {
		return device_info;
	}

	/**
	 * @param nonce_str	随机字符串
	 */
	public void setNonce_str(String nonce_str) {
		this.nonce_str = nonce_str;
	}

	/**
	 * @return	nonce_str	随机字符串
	 */
	@XmlElement(name = "nonce_str")
	public String getNonce_str() {
		return nonce_str;
	}

	/**
	 * @param sign	签名
	 */
	public void setSign(String sign) {
		this.sign = sign;
	}

	/**
	 * @return	sign	签名
	 */
	@XmlElement(name = "sign")
	public String getSign() {
		return sign;
	}

	/**
	 * @param sign_type	签名类型
	 */
	public void setSign_type(String sign_type) {
		this.sign_type = sign_type;
	}

	/**
	 * @return	sign_type	签名类型
	 */
	@XmlElement(name = "sign_type")
	public String getSign_type() {
		return sign_type;
	}

	/**
	 * @param body	商品描述
	 */
	public void setBody(String body) {
		this.body = body;
	}

	/**
	 * @return	body	商品描述
	 */
	@XmlElement(name = "body")
	public String getBody() {
		return body;
	}

	/**
	 * @param detail	商品详情
	 */
	public void setDetail(String detail) {
		this.detail = detail;
	}

	/**
	 * @return	detail	商品详情
	 */
	@XmlElement(name = "detail")
	public String getDetail() {
		return detail;
	}

	/**
	 * @param attach	附加数据
	 */
	public void setAttach(String attach) {
		this.attach = attach;
	}

	/**
	 * @return	attach	附加数据
	 */
	@XmlElement(name = "attach")
	public String getAttach() {
		return attach;
	}

	/**
	 * @param out_trade_no	商户订单号
	 */
	public void setOut_trade_no(String out_trade_no) {
		this.out_trade_no = out_trade_no;
	}

	/**
	 * @return	out_trade_no	商户订单号
	 */
	@XmlElement(name = "out_trade_no")
	public String getOut_trade_no() {
		return out_trade_no;
	}

	/**
	 * @param fee_type	标价币种
	 */
	public void setFee_type(String fee_type) {
		this.fee_type = fee_type;
	}

	/**
	 * @return	fee_type	标价币种
	 */
	@XmlElement(name = "fee_type")
	public String getFee_type() {
		return fee_type;
	}

	/**
	 * @param total_fee	标价金额
	 */
	public void setTotal_fee(int total_fee) {
		this.total_fee = total_fee;
	}

	/**
	 * @return	total_fee	标价金额
	 */
	@XmlElement(name = "total_fee")
	public int getTotal_fee() {
		return total_fee;
	}

	/**
	 * @param spbill_create_ip	终端IP
	 */
	public void setSpbill_create_ip(String spbill_create_ip) {
		this.spbill_create_ip = spbill_create_ip;
	}

	/**
	 * @return	spbill_create_ip	终端IP
	 */
	@XmlElement(name = "spbill_create_ip")
	public String getSpbill_create_ip() {
		return spbill_create_ip;
	}

	/**
	 * @param time_start	交易起始时间
	 */
	public void setTime_start(String time_start) {
		this.time_start = time_start;
	}

	/**
	 * @return	time_start	交易起始时间
	 */
	@XmlElement(name = "Time_start")
	public String getTime_start() {
		return time_start;
	}

	/**
	 * @param time_expire	交易结束时间
	 */
	public void setTime_expire(String time_expire) {
		this.time_expire = time_expire;
	}

	/**
	 * @return	time_expire	交易结束时间
	 */
	@XmlElement(name = "time_expire")
	public String getTime_expire() {
		return time_expire;
	}

	/**
	 * @param goods_tag	订单优惠标记
	 */
	public void setGoods_tag(String goods_tag) {
		this.goods_tag = goods_tag;
	}

	/**
	 * @return	goods_tag	订单优惠标记
	 */
	@XmlElement(name = "goods_tag")
	public String getGoods_tag() {
		return goods_tag;
	}

	/**
	 * @param notify_url	通知地址
	 */
	public void setNotify_url(String notify_url) {
		this.notify_url = notify_url;
	}

	/**
	 * @return	notify_url	通知地址
	 */
	@XmlElement(name = "notify_url")
	public String getNotify_url() {
		return notify_url;
	}

	/**
	 * @param trade_type	交易类型
	 */
	public void setTrade_type(String trade_type) {
		this.trade_type = trade_type;
	}

	/**
	 * @return	trade_type	交易类型
	 */
	@XmlElement(name = "trade_type")
	public String getTrade_type() {
		return trade_type;
	}

	/**
	 * @param product_id	商品ID
	 */
	public void setProduct_id(String product_id) {
		this.product_id = product_id;
	}

	/**
	 * @return	product_id	商品ID
	 */
	@XmlElement(name = "product_id")
	public String getProduct_id() {
		return product_id;
	}

	/**
	 * @param limit_pay	指定支付方式
	 */
	public void setLimit_pay(String limit_pay) {
		this.limit_pay = limit_pay;
	}

	/**
	 * @return	limit_pay	指定支付方式
	 */
	@XmlElement(name = "limit_pay")
	public String getLimit_pay() {
		return limit_pay;
	}

	/**
	 * @param openid	用户标识
	 */
	public void setOpenid(String openid) {
		this.openid = openid;
	}

	/**
	 * @return	openid	用户标识
	 */
	@XmlElement(name = "openid")
	public String getOpenid() {
		return openid;
	}

	/**
	 * @param scene_info	场景信息
	 */
	public void setScene_info(String scene_info) {
		this.scene_info = scene_info;
	}

	/**
	 * @return	scene_info	场景信息
	 */
	@XmlElement(name = "scene_info")
	public String getScene_info() {
		return scene_info;
	}
	
}
