package com.yd.dal.service.tencent.Impl;

import com.yd.dal.entity.tencent.TenInterfRecord;
import com.yd.dal.mapper.tencent.TenInterfRecordMapper;
import com.yd.dal.service.tencent.TenInterfRecordDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("tenInterfRecordDALService")
public class TenInterfRecordDALServiceImpl implements TenInterfRecordDALService {
    @Resource
    private TenInterfRecordMapper tenInterfRecordMapper;

    @Override
    public void saveTenInterfRecord(TenInterfRecord tencentInterfRecord) {
        tenInterfRecordMapper.insertSelective(tencentInterfRecord);
    }

    @Override
    public List<TenInterfRecord> findByTenInterfRecordOrderBy(TenInterfRecord tencentInterfRecord, String orderBy) {
        return tenInterfRecordMapper.findByTenInterfRecordOrderBy(tencentInterfRecord, orderBy);
    }

    @Override
    public List<TenInterfRecord> findByAppIdAndGrantType(String appId, String grantType) {
        return tenInterfRecordMapper.findByAppIdAndGrantType(appId,grantType,"TOKEN");
    }

    @Override
    public List<TenInterfRecord> findByAccessTokenAndIType(String accessToken, String pType) {
        return tenInterfRecordMapper.findByAccessTokenAndIType(accessToken,pType,"TICKET");
    }
}
