package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerFileSharing;
import com.yd.dal.mapper.customer.AclPractitionerFileSharingMapper;
import com.yd.dal.service.customer.AclPractitionerFileSharingDALService;
import com.yd.util.CommonUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @author xxy
 */
@Service("aclPractitionerFileSharingDALService")
public class AclPractitionerFileSharingDALServiceImpl implements AclPractitionerFileSharingDALService {

    @Resource
    private AclPractitionerFileSharingMapper mapper;

    @Override
    public Long saveOrUpdate(AclPractitionerFileSharing fileSharing) {
        if (CommonUtil.isNullOrZero(fileSharing.getId())){
            //没有id做保存
            fileSharing.setCreatedAt(new Date());
            fileSharing.setUpdatedAt(new Date());
            fileSharing.setCreatedBy(fileSharing.getUpdatedBy());
            mapper.insert(fileSharing);
        }else {
            //有id,做更新
            fileSharing.setUpdatedAt(new Date());
            mapper.updateByPrimaryKeySelective(fileSharing);
        }
        return fileSharing.getId();
    }
}
