package com.yd.dal.entity.customer;

import lombok.Data;

import java.util.Date;

/**
    * 報聘经纪人基本资料表
    */
@Data
public class AclPractitionerHiringBasicInfo {
    /**
    * serial id
    */
    private Long id;

    /**
     * 审批状态，包括待审批null及审批步骤seq，通过0，拒绝-1
     */
    private String approveStatus;

    /**
    * FK ag_acl_practitioner_potential，潜在经纪人增员表
    */
    private Long practitionerPotentialId;

    /**
    * FK ag_acl_practitioner.id 邀请人
    */
    private Long inviteePractitionerId;

    /**
    * 報聘经纪人姓名
    */
    private String name;

    /**
    * 報聘经纪人姓名电话
    */
    private String mobileNo;

    /**
    * FK ag_md_id_type.id
    */
    private Long idTypeId;

    /**
    * 報聘经纪人姓名证件类型
    */
    private String idType;

    /**
    * 報聘经纪人姓名证件号
    */
    private String idNo;

    /**
    * 1=Male, 2=Female
    */
    private Integer gender;

    /**
    * 報聘经纪人姓名生日
    */
    private String practitionerBirthdate;

    /**
    * 户籍省份 FK ag_md_province.id
    */
    private Long provinceId;

    /**
    * 户籍省份名
    */
    private String provinceName;

    /**
    * 户籍城市FK ag_md_city.id
    */
    private Long cityId;

    /**
    * 户籍城市名
    */
    private String cityName;

    /**
     * 政治面貌
     */
    private String politicalOutlook;

    /**
    * 居住地址
    */
    private String residentAddress;

    /**
    * 从业人员微信号
    */
    private String wechatId;

    /**
     * 从业人员微信二维码
     */
    private String wechatQRcodeOssPath;

    /**
    * email地址
    */
    private String email;

    /**
    * 个人照片
    */
    private String personerPictureOssPath;

    /**
     * 个人照片
     */
    private String payrollOssPath;

    /**
    * Id 正面照片
    */
    private String idFrontPageOssPath;

    /**
    * Id 反面照片
    */
    private String idBackPageOssPath;

    /**
     * 学历编码 FK ag_md_code.code_type:EducationLevel code_code
     */
    private String lastGraduateCode;

    /**
    * 最高学历
    */
    private String lastGraduateGrade;

    /**
    * 毕业学校
    */
    private String lastGraduateSchool;

    /**
    * 毕业证书
    */
    private String lastGraduateCertificationOssPath;

    /**
    * 开户行
    */
    private String bankAccountOpening;

    /**
    * 银行卡号
    */
    private String bankAccountId;

    /**
    * 个人签名
    */
    private String personalSignOssPath;

    /**
    * 0=No, 1=Yes
    */
    private Integer isActive;

    /**
    * 建置日
    */
    private Date createdAt;

    /**
    * 建置者
    */
    private Long createdBy;

    /**
    * 更新日
    */
    private Date updatedAt;

    private Long updatedBy;
}