package com.yd.api.practitioner.service;

import com.yd.api.practitioner.vo.hiring.*;
import org.springframework.stereotype.Service;

@Service
public interface PractitionerHiringService {

    SaveMembershipResponseVO saveMembership(SaveMembershipRequestVO requestVO);

    CommonResultResponseVO saveBasicInfo(SaveBasicInfoRequestVO requestVO);

    QueryMembershipResponseVO queryMembership(HiringBasicInfoIdRequestVO requestVO);

    CommonResultResponseVO saveWorkingExperience(SaveWorkingExperienceRequestVO requestVO);

    SavePersonPictureResponseVO savePersonPicture(SavePersonPictureRequestVO requestVO);

    SaveIDPictureResponseVO saveIDPicture(SaveIDPictureRequestVO requestVO);

    SaveLastGraduateGradeResponseVO saveLastGraduateGrade(SaveLastGraduateGradeRequestVO requestVO);

    CommonResultResponseVO savePersonalStatements(SavePersonalStatementsRequestVO requestVO);

    CommonResultResponseVO saveContractTermsConfirms(SaveContractTermsConfirmsRequestVO requestVO);
    /**
     * 经纪人审批列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    HiringListQueryResponseVO listQuery(HiringListQueryRequestVO requestVO);
    /**
     * 经纪人审批详情查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    HiringDetailQueryResponseVO detailQuery(HiringDetailQueryRequestVO requestVO);

    /**
     * ydLife经纪人审批
     * @param requestVO 请求数据
     * @return 响应数据
     */
    HiringApproveResponseVO hiringApprove(HiringApproveRequestVO requestVO);

    CommonResultResponseVO saveBankAccount(SaveBankAccountRequestVO requestVO);

    QueryContractTermsResponseVO queryContractTerms();

    QueryWholeInfoResponseVO queryWholeInfo(HiringBasicInfoIdRequestVO requestVO);

    CommonResultResponseVO saveDigitalSignatures(SaveDigitalSignaturesRequestVO requestVO);

    SavePayrollPictureResponseVO savePayrollPicture(SavePayRollPictureRequestVO requestVO);

    GeneratePDFResponseVO generatePDF(GeneratePDFRequestVO requestVO);

    QueryPractitionerInfoResponseVO queryPractitionerInfo(QueryPractitionerInfoRequestVO requestVO);

    CommonResultResponseVO hiringSubmit(HiringBasicInfoIdRequestVO requestVO);

    SaveWeChatQRcodeResponseVO saveWeChatQRcode(SaveWeChatQRcodeRequestVO requestVO);
}
