package com.yd.api.customer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.customer.service.CustomerTrackVideoService;
import com.yd.api.customer.vo.trackvideo.AddCustomerTrackVideoRequestVO;
import com.yd.api.customer.vo.trackvideo.QueryDetailsByIdResponseVO;
import com.yd.api.customer.vo.trackvideo.QueryTrackListRequestVO;
import com.yd.api.customer.vo.trackvideo.QueryTrackListResponseVO;
import com.yd.api.result.CommonResultResponseVO;
import com.yd.api.result.JsonResult;

/**
 *  rrWeb 可回溯录屏服务
 */
@RestController
@RequestMapping("/customerTrackVideo")
public class CustomerTrackVideoController {
	
	@Autowired
	private CustomerTrackVideoService customerTrackVideoService;

	/**
	 * rrWeb录屏数据保存与更新
	 * @param AddCustomerTrackVideoRequestVO
	 * @return CommonResultResponseVO
	 */
	@RequestMapping("/rrwebInfo")
	public Object rrWebInfo(@RequestBody AddCustomerTrackVideoRequestVO requestVO){
		JsonResult result = new JsonResult();
		CommonResultResponseVO responseVO = customerTrackVideoService.rrWebInfo(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 可回溯录屏列表查询接口
	 * @param QueryTrackListRequestVO
	 * @return QueryTrackListResponseVO
	 */
	@RequestMapping("/queryTrackList")
	public Object queryTrackList(@RequestBody QueryTrackListRequestVO requestVO){
		JsonResult result = new JsonResult();
		QueryTrackListResponseVO responseVO = customerTrackVideoService.queryTrackList(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 根据录屏ID查询可回溯录屏明细数据接口
	 * @param id
	 * @return QueryDetailsByIdResponseVO
	 */
	@RequestMapping("/queryDetailsById/{id}")
	public Object queryDetailsById(@PathVariable Long id){
		JsonResult result = new JsonResult();
		QueryDetailsByIdResponseVO responseVO = customerTrackVideoService.queryDetailsById(id);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

}