package com.yd.api.customer;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.customer.service.CustomerService;
import com.yd.api.customer.vo.CustomerFortuneRequestVO;
import com.yd.api.customer.vo.CustomerFortuneResponseVO;
import com.yd.api.customer.vo.CustomerQueryRequestVO;
import com.yd.api.customer.vo.CustomerQueryResponseVO;
import com.yd.api.customer.vo.CustomerVO;
import com.yd.api.result.JsonResult;

/*import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;

@Api(value="/customer", tags="用户接口:")*/
@RestController
public class CustomerController {
	
	@Autowired
	private CustomerService customerService;
	
    //@ApiOperation(value="查询所有用户信息", notes = "查询所有用户信息", httpMethod = "GET",response = Object.class)
	@RequestMapping("/listAllCustomer")
	public Object listAllCustomer(){
        JsonResult result = new JsonResult();

        List<CustomerVO> list = customerService.listAllCustomer();
       
        result.setData(list);

        return result;
	}	
	/**
	 * 分页查询案例
	 * @param customerQueryRequestVO
	 * @return
	 */
    //@ApiOperation(value="分页查询用户列表", notes = "分页查询用户列表", httpMethod = "POST",response = CustomerQueryResponseVO.class)
    //@ApiImplicitParam(name="customerQueryRequestVO", value="CustomerQueryRequestVO", required = true, dataType = "CustomerQueryRequestVO")	
	@RequestMapping("/findByPage")
	public Object findByPage(@RequestBody CustomerQueryRequestVO customerQueryRequestVO){
		JsonResult result = new JsonResult();
		CustomerQueryResponseVO erpOrderQueryResponseVO = customerService.findByPage(customerQueryRequestVO);
		result.addResult(erpOrderQueryResponseVO);
		result.setData(erpOrderQueryResponseVO);
		return result;
	}
	/**
	 * 分页查询案例
	 * @param customerQueryRequestVO
	 * @return
	 */
    //@ApiOperation(value="根据customerId分页查询用户财富", notes = "查询用户财富列表", httpMethod = "POST",response = CustomerFortuneResponseVO.class)
    //@ApiImplicitParam(name="customerFortuneRequestVO", value="CustomerFortuneRequestVO", required = true, dataType = "CustomerFortuneRequestVO")
	@RequestMapping("/selectByCustomerId")
	public Object selectByCustomerId(@RequestBody CustomerFortuneRequestVO customerFortuneRequestVO){
		JsonResult result = new JsonResult();
		CustomerFortuneResponseVO erpOrderQueryResponseVO = customerService.selectByCustomerId(customerFortuneRequestVO);
		result.addResult(erpOrderQueryResponseVO);
		result.setData(erpOrderQueryResponseVO);
		return result;
	}	
}