package com.yd.api.practitioner.service;

import com.yd.api.practitioner.vo.PractitionerIdRequestVO;
import com.yd.api.practitioner.vo.businessCard.PractitionerApplyEmailRequestVO;
import com.yd.api.practitioner.vo.businessCard.PractitionerBusinessCardRequestVO;
import com.yd.api.practitioner.vo.businessCard.PractitionerBusinessCardResponseVO;
import com.yd.api.practitioner.vo.commitment.QueryCommitmentByPractitionerIdResponseVO;
import com.yd.api.practitioner.vo.commitment.SignCommitmentRequestVO;
import com.yd.api.practitioner.vo.informed.*;
import com.yd.api.practitioner.vo.login.CanSeeSalaryListResponseVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.opportunity.*;
import com.yd.api.practitioner.vo.practitionerCustomer.*;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.recruit.*;
import com.yd.api.practitioner.vo.salestarget.*;
import com.yd.api.practitioner.vo.setting.*;
import com.yd.api.practitioner.vo.subordinate.SubordinateSystemMemberQueryRequestVO;
import com.yd.api.practitioner.vo.subordinate.SubordinateSystemMemberQueryResponseVO;
import com.yd.api.practitioner.vo.unionSales.SignUnionSalesRequestVO;
import com.yd.api.result.CommonResultIDResponseVO;
import com.yd.api.result.CommonResultResponseVO;
import com.yd.api.result.IDRequestVO;
import com.yd.api.result.JsonResult;
import com.yd.dal.entity.customer.AgPoInformed;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("practitionerService")
public interface PractitionerService {

    /**
     * 经纪人登录接口
     * @param requestVO 请求信息
     * @return PractitionerLoginResponseVO
     */
    PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO);

    /**
     * 经纪人排行榜查询
     * @param requestVO 请求信息
     * @return PractitionerRankResponseVO
     */
    PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO);

    /**
     * 经纪人设置查询
     * @param requestVO
     * @return
     */
    SettingQueryResponseVO settingQuery(SettingQueryRequestVO requestVO);

    /**
     * 经纪人删除头像生活照
     * @param requestVO
     * @return
     */
    ImgDeleteResponseVO imgDelete(ImgDeleteRequestVO requestVO);

    /**
     * 保存经纪人设置头像,生活照
     * @param requestVO
     * @return
     */
    SettingSaveResponseVO settingSave(SettingSaveRequestVO requestVO) throws Exception;

    /**
     * 微信上传图片
     * @param requestVO
     * @return
     */
    MediaGetRespVO mediaGet(MediaGetReqVO requestVO);

    /**
     * 经纪人查询自己的商机
     * @param requestVO
     * @return
     */
    OwnOpportunityQueryResponseVO ownOpportunityQuery(OwnOpportunityQueryRequestVO requestVO);

    /**
     * 经纪人查询自己的商机详情查询
     * @param requestVO
     * @return
     */
    OwnOpportunityDetailQueryResponseVO ownOpportunityDetailQuery(OwnOpportunityDetailQueryRequestVO requestVO);
    /**
     * 团队长--增员
     * @param requestVO 请求信息
     * @return responseVO
     */
    RecruitResponseVO recruit(RecruitRequestVO requestVO);
    /**
     * 团队长--新增增员记录
     * @param requestVO 请求信息
     * @return responseVO
     */
    AddRecruitTrackResponseVO addRecruitTrack(AddRecruitTrackRequestVO requestVO);

    /**
     * 团队长--增员记录查询
     * @param requestVO 请求信息
     * @return responseVO
     */
    RecruitTrackQueryResponseVO recruitTrackQuery(RecruitTrackQueryRequestVO requestVO);

    /**
     * 团队长--增员列表查询
     * @param requestVO 请求信息
     * @return responseVO
     */
    RecruitListResponseVO recruitListQuery(RecruitListRequestVO requestVO);

    /**
     * 修改商机基本信息
     * @param requestVO
     * @return
     */
    OwnOpportunityBasicInformationSaveResponseVO ownOpportunityBasicInformationSave(OwnOpportunityBasicInformationSaveRequestVO requestVO);

    /**
     * 保存商机跟进,修改商机基本信息
     * @param requestVO
     * @return
     */
    OwnOpportunityRecordSaveResponseVO ownOpportunityRecordSave(OwnOpportunityRecordSaveRequestVO requestVO);

    /**
     * ydLife查询此经纪人总分数  按年月周日 分别统计  新增商机个数  达成率
     * @param requestVO
     * @return
     */
    OpportunityStatisticsResponseVO opportunityStatistics(OpportunityStatisticsRequestVO requestVO);

    /**
     * 保存销售目标
     * @param requestVO
     * @return
     */
    SalesTargetSaveResponseVO salesTargetSave(SalesTargetSaveRequestVO requestVO);

    /**
     * 查询销售目标
     * @param requestVO
     * @return
     */
    SalesTargetQueryResponseVO salesTargetQuery(SalesTargetQueryRequestVO requestVO);

    /**
     * 保存月均目标
     * @param requestVO
     * @return
     */
    SalesTargetMonthSaveResponseVO salesTargetMonthSave(SalesTargetMonthSaveRequestVO requestVO);

    /**
     * 团队长-查看组员得分均值
     * @param requestVO
     * @return
     */
    TeamActionsAverageQueryResponseVO teamScoreAverageQuery(TeamActionsAverageQueryRequestVO requestVO);

    /**
     * 队员销售活动量
     * @param requestVO
     * @return
     */
    PlayerSalesActivityQueryResponseVO playerSalesActivityQuery(PlayerSalesActivityQueryRequestVO requestVO);

    /**
     * 销售业绩预测  保费/佣金/件数  月季年
     * @param requestVO
     * @return
     */
    SalesPerformanceForecastListQueryResponseVO salesPerformanceForecastListQuery(SalesPerformanceForecastListQueryRequestVO requestVO);
    /**
     * 体系团队成员信息查询
     * @param requestVO
     * @return
     */
    SubordinateSystemMemberQueryResponseVO subordinateSystemMemberQuery(SubordinateSystemMemberQueryRequestVO requestVO);
    /**
     * 保存增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsSettingResponseVO potentialGoalsSetting(PotentialGoalsSettingRequestVO requestVO);

    /**
     * 查询增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsQueryResponseVO potentialGoalsQuery(PotentialGoalsQueryRequestVO requestVO);
    /**
     * 查询增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsActionsQueryResponseVO potentialGoalsActionsQuery(PotentialGoalsActionsQueryRequestVO requestVO);

    /**
     * 团队长--更新增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsActionsUpdateResponseVO potentialGoalsActionsUpdate(PotentialGoalsActionsUpdateRequestVO requestVO);

    /**
     * 团队长--查看目前自己的活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialActivityQueryResponseVO potentialActivityQuery(PotentialActivityQueryRequestVO requestVO);

    /**
     * 经纪人-查看自己销售活动量分值详情
     * @param requestVO 请求数据
     * @return 响应数据
     */
    SalesScoreDetailQueryResponseVO salesScoreDetailQuery(SalesScoreDetailQueryRequestVO requestVO);

    /**
     * 申请专家支持
     * @param requestVO 请求信息
     * @return 响应信息
     */
    ApplyForExpertSupportResponseVO applyForExpertSupport(ApplyForExpertSupportRequestVO requestVO);

    /**
     * 经纪人-查看自己团队所有成员或自己所有被辅导人经纪人Id
     * @param practitionerId
     * @return
     */
    List<Long> getPractitionerIdList(Long practitionerId,Integer isActive);

    /**
     * 查询经纪人是否可以看薪资表
     * @return
     */
    CanSeeSalaryListResponseVO canSeeSalaryList(Long practitionerId);

    QueryCustomerHolderListResponesVO queryCustomerHolderList(Long practitionerId);

    QueryCustomerInsuredListResponesVO queryCustomerInsuredList(QueryCustomerInsuredListRequestVO requestVO);

    QueryPolicyListByHolderCustomerIdResponesVO queryPolicyListByHolderCustomerId(QueryPolicyListByHolderCustomerIdRequestVO requestVO);

    /**
     * 经纪人-根据体系id查询所在的经纪人
     * @param sid
     * @return
     */
    List<Long> getPractitionerIdBySidList(Long sId,String systemType,Integer isActive);

    CommonResultIDResponseVO saveInformedSheet(SaveInformedSheetRequestVO requestVO);

    QueryInformedSheetByIdResponseVO queryInformedSheetById(IDRequestVO requestVO);

    CommonResultIDResponseVO updateInformedSheetById(UpdateInformedSheetByIdRequestVO requestVO);

    CommonResultIDResponseVO signInformedSheet(SignInformedSheetRequestVO requestVO);

    QueryInformedSheetListResponseVO queryInformedSheetList(QueryInformedSheetListRequestVO requestVO);

    CommonResultIDResponseVO signCommitment(SignCommitmentRequestVO requestVO);

    QueryCommitmentByPractitionerIdResponseVO queryCommitmentByPractitionerId(PractitionerIdRequestVO requestVO);
    
    /**
     * 经纪人联合销售签名
     * @param SignUnionSalesRequestVO
     * @return CommonResultIDResponseVO
     * @author Yan Wenyang
     */
    CommonResultIDResponseVO signUnionSales(SignUnionSalesRequestVO requestVO);

    /**
     * 逻辑删除商机
     * @param OpportunityDeleteRequestVO
     * @return CommonResultIDResponseVO
     * @author Yan Wenyang
     */
    CommonResultIDResponseVO updateOpportunity(OpportunityDeleteRequestVO requestVO);

    /**
     * 经纪人名片
     * @param PractitionerBusinessCardRequestVO
     * @return PractitionerBusinessCardResponseVO
     * @author Yan Wenyang
     */
    PractitionerBusinessCardResponseVO businessCard(PractitionerBusinessCardRequestVO requestVO);

    /**
     * 经纪人申请开通邮箱
     * @param PractitionerApplyEmailRequestVO
     * @return CommonResultResponseVO
     * @author Yan Wenyang
     */
    CommonResultResponseVO applyEmail(PractitionerApplyEmailRequestVO requestVO);
    
}
