package com.yd.dal.service.customer;

import com.yd.dal.entity.customer.AclCustomerFortuneWithdraw;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xxy
 */
public interface AclCustomerFortuneWithdrawDALService {

    /**
     * 查询这些customerId最后一笔未完成的提现记录
     * @param customerIds 客户id
     * @return map customerId withdrawId
     */
    Map<Long, Long> findFinalWithdrawNoPayByCustomerIds(Set<Long> customerIds, Long payoutBatchId);

    /**
     * 通过id批量查询
     * @param withdrawUpdateIds ids
     * @return AclCustomerFortuneWithdraw
     */
    List<AclCustomerFortuneWithdraw> findByIds(List<Long> withdrawUpdateIds);

    /**
     * 批量更新
     * @param withdraws withdraws
     */
    void updateAll(List<AclCustomerFortuneWithdraw> withdraws);

    /**
     * 查询这些customerId最后一笔已完成的提现记录
     * @param customerIds 客户id
     * @return map customerId withdrawId
     */
    Map<Long, Long> findFinalWithdrawPayByCustomerIds(Set<Long> customerIds);

    Long save(AclCustomerFortuneWithdraw withdraw);

    /**
     * 通过fortuneIds 查询withdraw记录
     * @param fortuneIds
     * @return
     */
    List<AclCustomerFortuneWithdraw> findByFortuneIds(Long[] fortuneIds);
}
