package com.yd.api.market.service;


import com.yd.api.commission.vo.CommissionVO;
import com.yd.api.market.service.MarketService;
import com.yd.api.market.vo.announcement.AnnouncementInfoVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryRequestVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dataccess.entity.mkt.MktAnnouncement;
import com.yd.dataccess.service.mkt.MktAnnouncementServiceDA;
import com.yd.util.config.ZHBErrorConfig;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("marketService")
public class MarketServiceImpl implements MarketService {

    @Autowired
    private MktAnnouncementServiceDA mktAnnouncementServiceDA;

    @Override
    public AnnouncementQueryResponseVO announcementQuery(AnnouncementQueryRequestVO requestVO) {
    	AnnouncementQueryResponseVO responseVO = new AnnouncementQueryResponseVO();
    	
    	List<AnnouncementInfoVO> listTo =new ArrayList<AnnouncementInfoVO>();
		List<MktAnnouncement> list = new ArrayList<MktAnnouncement>();
		list = mktAnnouncementServiceDA.findByIsActiveAndAnnouncementAtBefore(1,new Date());
		AnnouncementInfoVO oneDestVO;
    	for(MktAnnouncement oneSrc:list)
    	{
    		oneDestVO = new AnnouncementInfoVO();
    		BeanUtils.copyProperties(oneSrc, oneDestVO);
    		listTo.add(oneDestVO);
    	}
    	
    	responseVO.setAnnouncementInfoList(listTo);
    	responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
    	
		return responseVO;
    }

	@Override
	public AnnouncementQueryResponseVO addAnnouncement(AnnouncementInfoVO announcementInfoVO) {
		AnnouncementQueryResponseVO announcementQueryResponseVO = new AnnouncementQueryResponseVO();
		MktAnnouncement oneDest = new MktAnnouncement();

		BeanUtils.copyProperties(announcementInfoVO, oneDest);

		MktAnnouncement one = mktAnnouncementServiceDA.insert(oneDest);
		
		List<AnnouncementInfoVO> announcementInfoList = new	ArrayList<AnnouncementInfoVO>();
		AnnouncementInfoVO oneVO = new AnnouncementInfoVO();
		BeanUtils.copyProperties(one, oneVO);
		announcementInfoList.add(oneVO);
		announcementQueryResponseVO.setAnnouncementInfoList(announcementInfoList);
		return announcementQueryResponseVO;
	}

	@Override
	public Integer update(AnnouncementInfoVO mktAnnouncement) {
		MktAnnouncement oneDest = new MktAnnouncement();

		BeanUtils.copyProperties(mktAnnouncement, oneDest);
		Integer result = mktAnnouncementServiceDA.update(oneDest);
		return result;
	}

	@Override
	public Integer delete(Long announcementType) {
		
		return mktAnnouncementServiceDA.delete(announcementType);
	}

}
