package com.yd.api.commission;


import com.yd.api.agms.vo.fortune.ExportFortunePayRequestVO;
import com.yd.api.agms.vo.fortune.ExportFortunePayResponseVO;
import com.yd.api.commission.service.LifeCommissionService;
import com.yd.api.commission.vo.lifecommission.*;
import com.yd.api.result.CommonResult;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 核实发放寿险经纪人佣金
 */
@RestController
public class LifeCommissionController {
	
	@Autowired
	private LifeCommissionService lifeCommissionService;

	/**
	 * 查询来佣比对列表
	 *
	 * @return
	 */
	@RequestMapping("/queryComeCommissionList")
	public Object queryComeCommissionList(@RequestBody QueryComeCommissionListRequestVO requestVO){
		JsonResult result = new JsonResult();
		ComeCommissionListResponseVO responseVO = lifeCommissionService.queryComeCommissionList(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 来佣比对
	 *
	 * @return
	 */
	@RequestMapping("/updateCommissionCheckStatus")
	public Object updateCommissionCheckStatus(@RequestBody CheckComeCommissionRequestVO requestVO){
		JsonResult result = new JsonResult();
		CheckComeCommissionResponseVO responseVO = lifeCommissionService.updateCommissionCheckStatus(requestVO);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * 来佣比对-历史比对年月列表查询
	 *
	 * @return
	 */
	@RequestMapping("/querycheckBatchList")
	public Object querycheckBatchList(){
		JsonResult result = new JsonResult();
		QuerycheckBatchListResponseVO responseVO = lifeCommissionService.querycheckBatchList();
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

	/**
	 * AGMS -- 来佣比对列表查询文件导出
	 * @param requestVO 请求数据
	 * @return 响应数据
	 */
	@RequestMapping(value="/exportComeCommission")
	public Object exportComeCommission(@RequestBody QueryComeCommissionListRequestVO requestVO, HttpServletResponse response) {
		JsonResult result = new JsonResult();
		ExportComeCommissionResponseVO responseVO = lifeCommissionService.exportComeCommission(requestVO, response);
		result.addResult(responseVO);
		result.setData(responseVO);
		return result;
	}

}