package com.yd.dal.entity.marketing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * ag_mkt_leads_assigned_track
 * @author 
 */
@Data
public class MktLeadsAssignedTrack implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_po_order.id 9元咨询服务订单销售记录（营销填写）
     */
    private Long orderId;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 询服务订单销售记录(营销填写)类似回访记录
     */
    private String salesNotice;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 分析建置时间
     */
    private Date createdAt;

    /**
     * 建置者 FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 创建者类型:1为user id（AGMS），2为本人practitioner id（银盾经纪）
     */
    private Integer creatorType;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 更新者 FK ag_acl_user.id
     */
    private Long updatedBy;

    /**
     * 更新者类型:1为user id（AGMS），2为本人practitioner id（银盾经纪）
     */
    private Integer updatorType;

    /**
     * 经纪人id
     */
    private Long practitionerId;

    /**
     * 经纪人商机对应的客户id
     */
    private Long customerId;

    /**
     * ag_md_drop_options.id 销售活动
     */
    private Long mdDropOptionId;

    /**
     * 线索发掘活动分值快照
     */
    private Integer trackScore;

    /**
     * FK ag_mkt_leads_assigneds.id 线索指派表
     */
    private Long leadsAssignedId;

    private Date trackTime;

    /**
     * 关联ag_mkt_schedule_task_tracking.id 日程表
     */
    private Long scheduleTaskTrackingId;
    /**
     * 告知书记录Id
     */
    private Long informedId;
    /**
     * 告知书url
     */
    private String informedOssPath;
    /**
     * 告知书签署状态
     */
    private String informedStatus;

    private static final long serialVersionUID = 1L;
}