package com.yd.rmi.n22.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.rmi.n22.common.utils.N22Utils;
import com.yd.rmi.n22.salary.pojo.*;
import com.yd.rmi.n22.salary.service.N22SalaryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class N22SalaryServiceImpl implements N22SalaryService {

    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public SalaryDetailsSearchResponseVO salaryDetailsSearch(SalaryDetailsSearchRequestBody salaryDetailsSearchRequestBody) {
        JSONObject obj = new JSONObject(); //接口传参

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", salaryDetailsSearchRequestBody);

        String url = systemConfigService.getSingleConfigValue("N22_URL_Salary_Details_Search");
        String result = N22Utils.postTransaction(url, obj.toString());

        SalaryDetailsSearchResponseVO response = JSONObject.parseObject(result, SalaryDetailsSearchResponseVO.class);

        return response;
    }

    @Override
    public SearchStaffAchievementResponseVO searchStaffAchievement(SearchStaffAchievementRequestBody searchStaffAchievementRequestBody) {
        JSONObject obj = new JSONObject(); //接口传参

        JSONObject requestHead = new JSONObject();
        requestHead.put("seqNo", UUID.randomUUID().toString());

        obj.put("requestHead", requestHead);
        obj.put("requestBody", searchStaffAchievementRequestBody);

        String url = systemConfigService.getSingleConfigValue("N22_URL_Salary_Details_Search");
        String result = N22Utils.postTransaction(url, obj.toString());

        SearchStaffAchievementResponseVO response = JSONObject.parseObject(result, SearchStaffAchievementResponseVO.class);

        return response;
    }
}
