package com.yd.dal.service.marketing.Impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.api.agms.vo.statistics.LeadsStatisticsInfo;
import com.yd.dal.entity.leads.LeadsStatusInfo;
import com.yd.dal.entity.marketing.MktLeadsPool;
import com.yd.dal.mapper.marketing.MktLeadsPoolMapper;
import com.yd.dal.service.marketing.MktLeadsPoolDALService;

@Service("mktLeadsPoolDALService")
public class MktLeadsPoolDALServiceImpl implements MktLeadsPoolDALService {
    @Resource
    private MktLeadsPoolMapper mktLeadsPoolMapper;

    @Override
    public MktLeadsPool findByCustomerId(Long customerId) {
        return mktLeadsPoolMapper.findByCustomerId(customerId);
    }

    @Override
    public void save(MktLeadsPool pool) {
        mktLeadsPoolMapper.insertSelective(pool);
    }

    @Override
    public List<LeadsStatisticsInfo> findByCondition(Integer isStatement,Integer leadsStatus,Integer expertApplyStatus,String leadsStartTime, String leadsEndTime) {
        return mktLeadsPoolMapper.findALLByDate(isStatement,leadsStatus,expertApplyStatus,leadsStartTime,leadsEndTime);
    }

    @Override
    public List<LeadsStatisticsInfo> findIsAssignLeads() {
        return mktLeadsPoolMapper.findIsAssignLeads();
    }

    @Override
    public Map<Long, Long> findLeadsStatusMap() {
        Map<Long, Long> leadsMap = new HashMap<>();
        List<LeadsStatusInfo> leadsStatusInfoList = mktLeadsPoolMapper.findLeadsStatusMap();
        leadsStatusInfoList.forEach(i->leadsMap.put(i.getLeadsCustomerId(),i.getLeadsStatusId()));
        return leadsMap;
    }

    @Override
    public PageInfo<LeadsStatisticsInfo> findByConditionPage(int pageNum, int size, Integer isStatement, Integer leadsStatus, Integer expertApplyStatus, String leadsStartTime, String leadsEndTime) {
        PageHelper.startPage(pageNum, size);
        Page<LeadsStatisticsInfo> statementData = mktLeadsPoolMapper.findALLByDate(isStatement,leadsStatus,expertApplyStatus,leadsStartTime,leadsEndTime);
        PageInfo<LeadsStatisticsInfo> pageInfo = new PageInfo<>(statementData);
        return pageInfo;
    }
    
    @Override
    public void updateMktLeadsAssigneds(MktLeadsPool pool){
    	mktLeadsPoolMapper.updateByPrimaryKeySelective(pool);
    }

    @Override
    public MktLeadsPool findByCustomerIdForSfp(Long customerId, Long sfpMainId) {
        return mktLeadsPoolMapper.findByCustomerIdForSfp(customerId, sfpMainId);
    }
    @Override
    public MktLeadsPool findBySfpMainId(Long sfpMainId) {
        return mktLeadsPoolMapper.findBySfpMainId(sfpMainId);
    }

}
