package com.yd.dal.entity.product;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ag_product
 * @author 
 */
@Data
public class Product implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_insurer.id
     */
    private Long insurerId;

    private String insurerName;

    /**
     * FK ag_acl_insurer_branch.id
     */
    private Long insurerBranchId;

    /**
     * FK ag_product_category.id
     */
    private Long productCategoryId;

    /**
     * Product#
     */
    private String no;

    /**
     * Product Chinese name/Description
     */
    private String name;

    /**
     * Product English name
     */
    private String nameEn;

    private String description;

    /**
     * 0000-00-00
     */
    private Date effectiveStartDate;

    /**
     * 0000-00-00
     */
    private Date effectiveEndDate;

    private BigDecimal salePrice;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 保单生效起始日计算 T+X 
     */
    private Integer policyEffCount;

    /**
     * 保单生效起始日计算单位 H=时 D=天 W=周 M=月 Y=年
     */
    private String policyEffCountUnit;

    /**
     * 最小保障期限
     */
    private Integer minCoverTerm;

    /**
     * 最小保障期限单位 H=时 D=天 W=周 M=月 Y=年
     */
    private String minCoverTermUnit;

    /**
     * 犹豫期，该产品订单的财富，只有过了犹豫期才能体现（H5）
     */
    private Integer hesitatePeroid;

    /**
     * 1人/天、1人/年
     */
    private String uiDisplayUnit;

    /**
     * 评测icon文章的url
     */
    private String articleUrl;

    /**
     * 是否银盾收保费 0=No, 1=Yes
     */
    private Integer isPayToYd;

    /**
     * 0000-00-00 00:00:00
     */
    private Date createdAt;

    /**
     * FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 0000-00-00 00:00:00
     */
    private Date updatedAt;

    /**
     * latest updator
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}