package com.yd.api.commission.service.impl;

import com.yd.api.commission.service.LifeCommissionService;
import com.yd.api.commission.vo.lifecommission.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.commission.OrderCommissonCheck;
import com.yd.dal.mapper.lifecommission.LifeCommissionMapper;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


@Service
public class LifeCommissionServiceImpl implements LifeCommissionService {

    @Autowired
    private LifeCommissionMapper lifeCommissionMapper;

    @Override
    public ComeCommissionListResponseVO queryComeCommissionList(QueryComeCommissionListRequestVO requestVO) {
        ComeCommissionListResponseVO resp = new ComeCommissionListResponseVO();
        try {
            List<ComeCommissionVO> dataList = lifeCommissionMapper.queryComeCommissionList(requestVO);

            resp.setDataList(dataList);
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    @Override
    public CheckComeCommissionResponseVO checkComeCommission(CheckComeCommissionRequestVO requestVO) {
        CheckComeCommissionResponseVO resp = new CheckComeCommissionResponseVO();
        List<Long> orderIds = requestVO.getOrderIds();
        String status = null;
        String loginId = requestVO.getLoginId();
        try {
            // 插入批次表信息
            OrderCommissonCheck orderCommissionCheck= this.batchInsertOrderCommissionCheck(orderIds, loginId);
            System.out.println("看看主键回写");
            System.out.println(orderCommissionCheck);

            this.checkComeCommission(orderIds, status, orderCommissionCheck);

            //TODO 处理withdraw表 和   pay表

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    private void checkComeCommission(List<Long> orderIds, String status, OrderCommissonCheck orderCommissionCheck) {

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("checkId", orderCommissionCheck.getId());
        paramMap.put("status", status);
        paramMap.put("checkAt", orderCommissionCheck.getCreatedAt());
        paramMap.put("checkBy", orderCommissionCheck.getCreatedBy());

        lifeCommissionMapper.checkComeCommission(orderIds, paramMap);
    }

    private OrderCommissonCheck batchInsertOrderCommissionCheck(List<Long> orderIds, String loginId) {
        // 获取当前时间
        Date curDate = new Date();
        // 获取代表批次的年月
        String yearmonth = CommonUtil.dateParseString(curDate, "yyyy-MM");
        System.out.println("看看年月");
        System.out.println(yearmonth);

        OrderCommissonCheck orderCommissonCheck = new OrderCommissonCheck();
        orderCommissonCheck.setCheckYearmonth(yearmonth);
        orderCommissonCheck.setCreatedAt(curDate);
        orderCommissonCheck.setCreatedBy(loginId);

        return lifeCommissionMapper.insertOrderCommissionCheck(orderCommissonCheck);
    }
}
