package com.yd.api.commission.service.impl;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.api.agms.service.AgmsFortuneService;
import com.yd.api.order.vo.SurrenderFortuneRequestVO;
import com.yd.api.commission.service.LifeCommissionService;
import com.yd.api.commission.vo.lifecommission.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.commission.OrderCommissonCheck;
import com.yd.dal.entity.customer.AclCustomerFortune;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.mapper.lifecommission.LifeCommissionMapper;
import com.yd.dal.service.agms.AgmsFortuneDALService;
import com.yd.dal.service.customer.AclCustomerFortuneDALService;
import com.yd.dal.service.order.PoOrderDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;


@Service
public class LifeCommissionServiceImpl implements LifeCommissionService {

    @Autowired
    private LifeCommissionMapper lifeCommissionMapper;
    @Autowired
    private AgmsFortuneDALService agmsFortuneDALService;
    @Autowired
    private AclCustomerFortuneDALService customerFortuneDalService;
    @Autowired
    private AgmsFortuneService agmsFortuneService;
    @Autowired
    private PoOrderDALService poOrderDALService;


    @Override
    public ComeCommissionListResponseVO queryComeCommissionList(QueryComeCommissionListRequestVO requestVO) {
        ComeCommissionListResponseVO resp = new ComeCommissionListResponseVO();
        try {
            // 分页结果集
            PageInfo<ComeCommissionVO> pageInfo = this.queryComeCommissionListPage(requestVO);
            // 不分页结果集统计总单数，总保费，总来佣
            List<ComeCommissionVO> dataList = lifeCommissionMapper.queryComeCommissionList(requestVO);
            this.getSummaries(resp, dataList);

            resp.setPage(pageInfo);
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    private void getSummaries(ComeCommissionListResponseVO resp, List<ComeCommissionVO> dataList) {
        Integer totalSingular = dataList.size();
        BigDecimal totalOrderPrice = BigDecimal.ZERO;
        BigDecimal totalCommission = BigDecimal.ZERO;

        for (ComeCommissionVO item: dataList) {
            totalOrderPrice.add(new BigDecimal(item.getOrderPrice()));
            totalCommission.add(new BigDecimal(item.getCommissionAmount()));
        }
        resp.setTotalOrderPrice(totalOrderPrice);
        resp.setTotalSingular(totalSingular);
        resp.setTotalCommission(totalCommission);
    }

    @Override
    public CheckComeCommissionResponseVO updateCommissionCheckStatus(CheckComeCommissionRequestVO requestVO) {
        CheckComeCommissionResponseVO resp = new CheckComeCommissionResponseVO();
        List<Long> orderIds = requestVO.getOrderIds();
        String status = requestVO.getCheckStatus();
        String loginId = requestVO.getLoginId();
        try {
            // 寿险经纪人的财富需要初始化withdraw和pay
            if ("2".equals(status)) {//已比对
                // 插入批次表信息
                OrderCommissonCheck orderCommissionCheck= this.batchInsertOrderCommissionCheck(orderIds, loginId);
                // 设置order记录的CommissionCheckId
                this.setOrderCommissionCheckId(orderIds, status, orderCommissionCheck);
                // 查询保单下的所有寿险经纪人的fortune记录
                List<AclCustomerFortune> fortuneList = agmsFortuneDALService.queryLifeFortuneListByOrderIds(orderIds);
                // 批量设置fortune为可发佣
                fortuneList.forEach(f -> {
                    f.setCommissionPayoutStatus("2");
                    f.setCommissionPayoutAt(new Date());
                    f.setCommissionPayoutBy(Long.getLong(loginId));
                });
                customerFortuneDalService.updateBatch(fortuneList);
                // 初始化withdraw和pay
                agmsFortuneService.canPaymentUpDate("2", Long.getLong("-1"), Long.getLong(loginId), fortuneList);

            } else if ("3".equals(status)) {//已退保
                SurrenderFortuneRequestVO surrenderFortuneRequest = new SurrenderFortuneRequestVO();
                for (Long orderId: orderIds) {
                    surrenderFortuneRequest.setOrderId(orderId);
                    agmsFortuneService.surrenderFortune(surrenderFortuneRequest);
                }
            } else {//待来佣
                // 设置order记录为待来佣
                List<PoOrder> orders = poOrderDALService.findByIds(orderIds);
                orders.forEach(o -> {
                    o.setCommissionCheckId(null);
                    o.setCommissionCheckStatus("1");
                    o.setCommissionCheckAt(new Date());
                    o.setCommissionCheckBy(Long.getLong(loginId));
                    poOrderDALService.update(o);
                });
                // 查询保单下的所有寿险经纪人的fortune记录
                List<AclCustomerFortune> fortuneList = agmsFortuneDALService.queryLifeFortuneListByOrderIds(orderIds);
                // 批量设置fortune为b不可发佣
                fortuneList.forEach(f -> {
                    f.setCommissionPayoutStatus("1");
                    f.setCommissionPayoutAt(new Date());
                    f.setCommissionPayoutBy(Long.getLong(loginId));
                });
                customerFortuneDalService.updateBatch(fortuneList);
            }
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }

    private PageInfo<ComeCommissionVO> queryComeCommissionListPage(QueryComeCommissionListRequestVO requestVO) {
        PageInfo<ComeCommissionVO> page = requestVO.getPage();

        String orderBy = "created_at desc";

        PageHelper.startPage(page.getPageNum(), page.getSize(), orderBy);

        List<ComeCommissionVO> dataList = lifeCommissionMapper.queryComeCommissionList(requestVO);
        page.setList(dataList);

        return page;
    }

    private void setOrderCommissionCheckId(List<Long> orderIds, String status, OrderCommissonCheck orderCommissionCheck) {

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("checkId", orderCommissionCheck.getId());
        paramMap.put("status", status);
        paramMap.put("checkAt", orderCommissionCheck.getCreatedAt());
        paramMap.put("checkBy", orderCommissionCheck.getCreatedBy());

        lifeCommissionMapper.setOrderCommissionCheckId(orderIds, paramMap);
    }

    private OrderCommissonCheck batchInsertOrderCommissionCheck(List<Long> orderIds, String loginId) {
        // 获取当前时间
        Date curDate = new Date();
        // 获取代表批次的年月
        String yearmonth = CommonUtil.dateParseString(curDate, "yyyy-MM");
        System.out.println("看看年月");
        System.out.println(yearmonth);

        OrderCommissonCheck orderCommissonCheck = new OrderCommissonCheck();
        orderCommissonCheck.setCheckYearmonth(yearmonth);
        orderCommissonCheck.setCreatedAt(curDate);
        orderCommissonCheck.setCreatedBy(loginId);

        return lifeCommissionMapper.insertOrderCommissionCheck(orderCommissonCheck);
    }
}
