package com.yd.dal.service.order.Impl;

import com.yd.dal.entity.order.CustomerPolicyInfo;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.entity.order.PolicyDetailInfoE;
import com.yd.dal.entity.order.PolicyFactorInfoE;
import com.yd.dal.mapper.order.PoOrderMapper;
import com.yd.dal.service.order.PoOrderDALService;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("poOrderDALService")
public class PoOrderDALServiceImpl implements PoOrderDALService {
    @Resource
    private PoOrderMapper poOrderMapper;

    @Override
    public List<PoOrder> findByStatusAndShareCodeInGroupByCustomerId(int status, List<String> customerShareCodes) {
        return poOrderMapper.findByStatusAndShareCodeInGroupByCustomerId(status , customerShareCodes);
    }

    @Override
    public PoOrder findByOrderId(Long orderId) {
        return poOrderMapper.selectByPrimaryKey(orderId);
    }

    @Override
    public List<CustomerPolicyInfo> findPolicyInfoByCustomerId(Long customerId, Integer time) {
        return poOrderMapper.findPolicyInfoByCustomerId(customerId,time);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<CustomerPolicyInfo> findPolicyInfoByMobileNoE(String mobileNo, Integer time) {
        return poOrderMapper.findPolicyInfoByMobileNoE(mobileNo,time);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public String findOrderNoByPolicyNo(String policyNo) {
        return poOrderMapper.findOrderNoByPolicyNo(policyNo);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<PolicyDetailInfoE> findPolicyDetailsInfoByOrderNoE(String orderNo) {
        return poOrderMapper.findPolicyDetailsInfoByOrderNoE(orderNo);
    }

    @Override
    @TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
    public List<PolicyFactorInfoE> findPolicyFactorByOrderNosE(List<String> orderNoList) {
        return poOrderMapper.findPolicyFactorByOrderNosE(orderNoList);
    }

    @Override
    public PoOrder findByIdAndStatus(Long orderId, int status) {
        return poOrderMapper.findByIdAndStatus(orderId, status);
    }

    @Override
    public void update(PoOrder poOrder) {
        poOrderMapper.updateByPrimaryKeySelective(poOrder);
    }

    @Override
    public List<PoOrder> findByIds(List<Long> orderIds) {
        return poOrderMapper.findByIds(orderIds);
    }

    @Override
    public List<Long> findVehiclePolicyInfoByCustomerId(Long customerId) {
        return poOrderMapper.findVehiclePolicyInfoByCustomerId(customerId);
    }

    @Override
    public List<PoOrder> findByPolicyNo(String policyNo) {
        return poOrderMapper.findByPolicyNo(policyNo);
    }
}
