package com.yd.api.practitioner.service.impl;

import com.google.common.base.Strings;
import com.yd.api.practitioner.service.PractitionerPolicyService;
import com.yd.api.practitioner.vo.policy.PolicyInfo;
import com.yd.api.practitioner.vo.policy.PolicyListQueryRequestVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryResponseVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryRequestVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryResponseVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.meta.OptionsEGolden;
import com.yd.dal.entity.order.CustomerPolicyInfo;
import com.yd.dal.entity.order.PolicyDetailInfoE;
import com.yd.dal.entity.product.Product;
import com.yd.dal.entity.product.ProductE;
import com.yd.dal.entity.product.ProductPlan;
import com.yd.dal.service.customer.AclPractitionerDALService;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.dal.service.order.PoOrderDALService;
import com.yd.dal.service.product.ProductDALService;
import com.yd.dal.service.product.ProductPlanDALService;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("practitionerPolicyService")
public class PractitionerPolicyServiceImpl implements PractitionerPolicyService {

    @Autowired
    private AclPractitionerDALService aclPractitionerDALService;
    @Autowired
    private PoOrderDALService poOrderDALService;
    @Autowired
    private ProductPlanDALService productPlanDALService;
    @Autowired
    private ProductDALService productDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;
    @Override
    public PolicyListQueryResponseVO policyListQuery(PolicyListQueryRequestVO requestVO) {
        PolicyListQueryResponseVO responseVO = new PolicyListQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        if(practitionerId !=null){
            String mobileNo = aclPractitionerDALService.findMobileNoByPractitionerId(practitionerId);
            if(!Strings.isNullOrEmpty(mobileNo) && mobileNo.length() == 11){
                List<PolicyInfo> policyInfoList = new ArrayList<>();
                Integer time = requestVO.getTime();
                time = (time == null) ? 1 : time;
                //1、线上
                getPolicyListForYD(policyInfoList,practitionerId,time);
                //2、线下
                getPolicyListForEGolden(policyInfoList,mobileNo,time);
                responseVO.setPolicyInfoList(policyInfoList);
                Collections.sort(policyInfoList);
                responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
            }else{
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("820001")));
            }
        }else{
            String[] params = {"practitionerId"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", params)));
        }
        return responseVO;
    }

    @Override
    public PolicyInfoQueryResponseVO policyInfoQuery(PolicyInfoQueryRequestVO requestVO) {
        PolicyInfoQueryResponseVO responseVO = new PolicyInfoQueryResponseVO();
        String orderNo = requestVO.getOrderNo();
        String policyNo = requestVO.getPolicyNo();
        if(!Strings.isNullOrEmpty(orderNo) || !Strings.isNullOrEmpty(policyNo)){
            Integer platform = requestVO.getPlatform();
            platform = (platform == null) ? 1 : platform;
            if(platform == 2){//EGolden
                //1、EGolden--获取orderNo
                orderNo = (Strings.isNullOrEmpty(orderNo)) ? getOrderNoE(policyNo) : orderNo;
                //2、根据orderNo获取保单和被保人的相关数据
                List<PolicyDetailInfoE> policyDetailInfoES = poOrderDALService.findPolicyDetailsInfoByOrderNoE(orderNo);
                if(!policyDetailInfoES.isEmpty()){
                    getResponseMessage(responseVO,policyDetailInfoES);
                    responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else if(platform == 1){//YD
                responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
            }
        }else{
            String[] params = {"orderNo,policyNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610002", params)));
        }
        return responseVO;
    }

    private String getOrderNoE(String policyNo) {
        String orderNo = null;
        if(!Strings.isNullOrEmpty(policyNo)){
            orderNo = poOrderDALService.findOrderNoByPolicyNo(policyNo);
        }
        return orderNo;
    }

    private void getResponseMessage(PolicyInfoQueryResponseVO responseVO, List<PolicyDetailInfoE> policyDetailInfoES) {
        if(!policyDetailInfoES.isEmpty()){
            List<Integer> materIds = Arrays.asList(20); // 20--保单状态
            List<OptionsEGolden> optionsEGoldenList = mdDropOptionsDALService.findByMasterIds(materIds);
        }
    }

    /**
     * EGolden--查询经纪人保单列表
     * @param policyInfoList 保单列表
     * @param mobileNo 手机号码
     * @param time 时间段
     */
    private void getPolicyListForEGolden(List<PolicyInfo> policyInfoList, String mobileNo, Integer time) {
        if(!Strings.isNullOrEmpty(mobileNo)){
            PolicyInfo policyInfo ;
            List<CustomerPolicyInfo> policyInfos = poOrderDALService.findPolicyInfoByMobileNoE(mobileNo,time);
            if(!policyInfos.isEmpty()){
                String productId ;
                Map<String,String> productNameMap = new HashMap<>();
                List<ProductE> products = productDALService.findAllE();
                products.forEach(i->productNameMap.put(i.getProductId(),i.getProductName()));
                for(CustomerPolicyInfo item : policyInfos){
                    policyInfo = new PolicyInfo();
                    productId = item.getProductName();
                    BeanUtils.copyProperties(item,policyInfo);
                    policyInfo.setProductName(productNameMap.get(productId));
                    policyInfo.setPlatform(2);
                    policyInfoList.add(policyInfo);
                }
            }
        }
    }

    /**
     * 银盾保险在线--查询经纪人保单列表
     * @param policyInfoList 保单列表
     * @param practitionerId 经纪人id
     * @param time 时间段
     */
    private void getPolicyListForYD(List<PolicyInfo> policyInfoList, Long practitionerId, Integer time) {
        if(practitionerId != null ){
            AclPractitioner practitioner = aclPractitionerDALService.findById(practitionerId);
            Long customerId = practitioner.getCustomerId();
            if(customerId != null){
                List<CustomerPolicyInfo> policyInfos = poOrderDALService.findPolicyInfoByCustomerId(customerId,time);
                if(!policyInfos.isEmpty()){
                    PolicyInfo policyInfo ;
                    Map<Long,String> planNameMap = new HashMap<>();
                    Map<Long,String> productNameMap = new HashMap<>();
                    List<ProductPlan> plans = productPlanDALService.findAll();
                    List<Product> products = productDALService.findAll();
                    products.forEach(i->productNameMap.put(i.getId(),i.getName()));
                    plans.forEach(i->planNameMap.put(i.getId(),i.getName()));
                    Long planId ;
                    for(CustomerPolicyInfo item : policyInfos){
                        planId = item.getPlanId();
                        policyInfo = new PolicyInfo();
                        BeanUtils.copyProperties(item,policyInfo);
                        if(planId != null){
                            policyInfo.setPlanName(planNameMap.get(planId));
                            policyInfo.setNoPlanProduct(false);
                        }else{
                            policyInfo.setProductName(productNameMap.get(item.getProductId()));
                            policyInfo.setNoPlanProduct(true);
                        }
                        policyInfo.setPlatform(1);
                        policyInfoList.add(policyInfo);
                    }
                }
            }
        }
    }
}
