package com.yd.api.metadata;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.metadata.service.MetadataService;
import com.yd.api.metadata.vo.TagQueryRequestVO;
import com.yd.api.metadata.vo.TagQueryResponseVO;
import com.yd.api.metadata.vo.TagViewQueryRequestVO;
import com.yd.api.metadata.vo.TagViewQueryResponseVO;
import com.yd.api.result.JsonResult;

/**
 * @author xxy
 * @date 2021年06月21日 17:14
 */
@RestController
@RequestMapping("/metadata")
public class MetadataController {

    @Autowired
    public MetadataService metadataService;

    /**
     * 标签合集查询
     * @param requestVO
     * @return TagQueryResponseVO
     */
    @RequestMapping("/tagQuery")
    public Object tagQuery(@RequestBody TagQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        TagQueryResponseVO responseVO = metadataService.tagQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 前端显示标签合集查询
     * @param requestVO
     * @return TagViewQueryResponseVO
     * @date 2021年06月21日 17:14
     */
    @RequestMapping("/tagViewQuery")
    public Object tagViewQuery(@RequestBody TagViewQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        TagViewQueryResponseVO responseVO = metadataService.tagViewQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

}
