package com.yd.dal.service.customer.impl;

import com.yd.api.practitioner.vo.recruit.PractitionerPotentialInfo;
import com.yd.dal.entity.customer.AclPractitionerPotential;
import com.yd.dal.mapper.customer.AclPractitionerPotentialMapper;
import com.yd.dal.service.customer.AclPractitionerPotentialDALService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
@Service("aclPractitionerPotentialDALService")
public class AclPractitionerPotentialDALServiceImpl implements AclPractitionerPotentialDALService {

    @Autowired
    private AclPractitionerPotentialMapper aclPractitionerPotentialMapper;
    @Override
    public List<AclPractitionerPotential> findByMobileNo(String mobileNo, Integer isActive) {
        return aclPractitionerPotentialMapper.findByMobileNo(mobileNo,isActive);
    }

    @Override
    public int update(AclPractitionerPotential practitionerPotential) {
        return aclPractitionerPotentialMapper.updateByPrimaryKeySelective(practitionerPotential);
    }

    @Override
    public List<PractitionerPotentialInfo> findByPractitionerIdAndLasted(Long practitionerId) {
        return aclPractitionerPotentialMapper.findByPractitionerIdAndLasted(practitionerId) ;
    }

    @Override
    public int save(AclPractitionerPotential practitionerPotential) {
        return aclPractitionerPotentialMapper.insert(practitionerPotential);
    }
}
