package com.yd.api.agms.service;

import com.yd.api.agms.vo.fortune.*;
import com.yd.api.order.vo.SurrenderFortuneRequestVO;
import com.yd.api.order.vo.SurrenderFortuneResponseVO;
import com.yd.dal.entity.customer.AclCustomerFortune;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * @author xxy
 */
public interface AgmsFortuneService {
    /**
     * AGMS -- 修改佣金发放状态
     * @param requestVO 请求数据
     * @return 响应数据
     */
    CommissionPayoutStatusUpdateResponseVO commissionPayoutStatusUpdate(CommissionPayoutStatusUpdateRequestVO requestVO);

    /**
     * AGMS -- 修改佣金发放状态
     * @param requestVO 请求数据
     * @return 响应数据
     * @throws InvocationTargetException InvocationTargetException
     * @throws IllegalAccessException IllegalAccessException
     */
    CommissionPayoutStatusQueryResponseVO commissionPayoutStatusQuery(CommissionPayoutStatusQueryRequestVO requestVO) throws InvocationTargetException, IllegalAccessException;

    /**
     * AGMS -- 支付列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    WithdrawQueryResponseVO withdrawQuery(WithdrawQueryRequestVO requestVO) throws InvocationTargetException, IllegalAccessException ;

    /**
     * AGMS -- 提现财富对应订单查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    FortunePayToOrderResponseVO fortunePayToOrder(FortunePayToOrderRequestVO requestVO);

    SurrenderFortuneResponseVO surrenderFortune(SurrenderFortuneRequestVO requestVO);

    public void canPaymentUpDate(String paymentStatus, Long payoutBatchId , Long loginId, List<AclCustomerFortune> customerFortunes);

}
