package com.yd.api.market;

import com.yd.api.result.JsonResult;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;

import com.yd.api.market.service.MarketService;
import com.yd.api.market.vo.announcement.AnnouncementInfoVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryRequestVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryResponseVO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/market", tags="Market接口:")
@RestController
public class MarketController {

    @Autowired
    private MarketService marketService;

    /**
     * 市场公告查询接口
     * @param requestVO
     * @return AnnouncementQueryResponseVO
     */
    @ApiOperation(value="按分类查询市场公告", notes = "按分类查询市场公告", httpMethod = "POST",response = AnnouncementQueryRequestVO.class)
    @ApiImplicitParam(name="requestVO", value="AnnouncementQueryRequestVO", required = true, dataType = "AnnouncementQueryRequestVO")    
    @RequestMapping("/announcementQuery")
    public Object announcementQuery(@RequestBody AnnouncementQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        AnnouncementQueryResponseVO responseVO = marketService.announcementQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    /**
     * 添加案例，返回自增id，以建立关联
     * @param announcementInfoVO
     * @return
     */
    @ApiOperation(value="添加市场公告", notes = "添加市场公告", httpMethod = "POST",response = AnnouncementQueryRequestVO.class)
    @ApiImplicitParam(name="announcementInfoVO", value="AnnouncementInfoVO", required = true, dataType = "AnnouncementInfoVO")        
    @RequestMapping("/addannouncement")
    public Object addAnnouncement(@RequestBody AnnouncementInfoVO announcementInfoVO){
        JsonResult result = new JsonResult();
        AnnouncementQueryResponseVO responseVO = marketService.addAnnouncement(announcementInfoVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }    
    /**
     * 修改案例
     * @param announcementInfoVO
     * @return
     */
    @ApiOperation(value="修改市场公告", notes = "修改市场公告", httpMethod = "POST",response = AnnouncementQueryRequestVO.class)
    @ApiImplicitParam(name="announcementInfoVO", value="AnnouncementInfoVO", required = true, dataType = "AnnouncementInfoVO")    
    @RequestMapping("/updateannouncement")
    public Object updateAnnouncement(@RequestBody AnnouncementInfoVO announcementInfoVO){
        JsonResult result = new JsonResult();
        int rows = marketService.update(announcementInfoVO);
        result.setData(rows);
        return result;
    } 
    /**
     * 删除案例
     * @param announcementInfoVO
     * @return
     */
    @ApiOperation(value="删除市场公告", notes = "删除市场公告", httpMethod = "POST",response = AnnouncementQueryRequestVO.class)
    @ApiImplicitParam(name="announcementInfoVO", value="AnnouncementInfoVO", required = true, dataType = "AnnouncementInfoVO")        
    @RequestMapping("/deleteannouncement")
    public Object deleteAnnouncement(@RequestBody AnnouncementInfoVO announcementInfoVO){
        JsonResult result = new JsonResult();
        int rows = marketService.delete(announcementInfoVO.getAnnouncementType());
        result.setData(rows);
        return result;
    }     
}
